package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;


/** World object updater
 *
 * World object updater listens for world change events and updates world object tracked by {@link IWorldObjectRegistry}.
 * 
 * @author Paletz
 */
public interface IWorldObjectUpdater {
	
	/** Apply world object update
	 * 
	 * @param event world object update event
	 */
	void applyWorldObjectUpdate( IWorldChangeEvent event );
	
	/** Set world object registry to receive updates
	 * 
	 * @param worldObjectRegistry world object registry to receive updates
	 */
	void initWorldObjectRegistry( IWorldObjectRegistry worldObjectRegistry );

	/** Set simulation clock to pull time from
	 * 
	 * @param simulationClock simulation clock to pull time from
	 */
	void initSimulationClock(ISimulationClock simulationClock );
}
