package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.utils.listener.IListener;

public class ViewableObjectRegistry extends WorldObjectRegistry implements IViewableObjectRegistry {

	/** Visible world object listing
	 */
	protected ObjectListing<WorldObjectId, IViewable> visibleObjectListing;
	
	public ViewableObjectRegistry() {
		visibleObjectListing = new ObjectListing<WorldObjectId, IViewable>();
	}
	
	@Override
	public IObjectListing<WorldObjectId, IViewable> getVisibleObjectListing() {
		return visibleObjectListing;
	}

	/** Clear all registries
	 */
	public void clear() {
		super.clear();
		visibleObjectListing.clear();
	}
	
	@Override
	public void registerObject( IWorldObject object, SimulationTime time ) {
		super.registerObject( object, time );
		
		if ( object instanceof IViewable ) {
			updateVisibilityTracking( (IViewable) object, time );
		}
	}
	
	@Override
	public void notifyObjectUpdated( IWorldObject object, SimulationTime time ) {
		
		if ( object instanceof IViewable ) {
			updateVisibilityTracking( (IViewable) object, time );
		}
		
		super.notifyObjectUpdated( object, time );
	}
	
	@Override
	public void forgetObject( IWorldObject object, SimulationTime time ) {
		
		if ( object instanceof IViewable ) {
			updateVisibilityTracking( (IViewable) object, false, time );
		}
		
		super.forgetObject( object, time );
	}
	
	protected void updateVisibilityTracking( IViewable object, SimulationTime time ) {
		updateVisibilityTracking( object, object.isVisible(), time );
	}
	
	protected void updateVisibilityTracking( IViewable object, boolean isActuallyVisible, SimulationTime time ) {
		boolean isTrackedVisible = visibleObjectListing.getMap().containsKey( object.getId() );
		
		if ( isActuallyVisible && !isTrackedVisible ) {
			visibleObjectListing.add( object.getId(), object );
			assert( worldObjectListing.getById( object.getId() ) != null );
			worldObjectEventListeners.notify( 
				new IListener.Notifier<IListener<IWorldObjectEvent<?>>>(
					new WorldObjectAppearedEvent<IViewable>( object, time.getMilliSeconds() )
				)
			);
		} else if ( !isActuallyVisible && isTrackedVisible ) {
			visibleObjectListing.remove( object.getId() );
			worldObjectEventListeners.notify( 
				new IListener.Notifier<IListener<IWorldObjectEvent<?>>>(
					new WorldObjectDisappearedEvent<IViewable>( object, time.getMilliSeconds() )
				)
			);
		}		
	}
}
