package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectDestroyedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.SimulationTime;
import cz.cuni.amis.utils.listener.IListener;

/** Registry of world objects.
 * 
 * Provides object tracking and event firing.
 * 
 * @author Paletz
 */
public interface IWorldObjectRegistry {
	
	/** Register object added/changed/removed listener
	 * 
	 * @param listener listener
	 */
	void registerObjectEventListener( IListener<IWorldObjectEvent<?>> listener );
	
	/** Forget object added/changed/removed listener
	 * 
	 * @param listener listener
	 */
	void forgetObjectEventListener( IListener<IWorldObjectEvent<?>> listener );
	
	/** Get world object listing
	 *
	 * @return world object listing
	 */
	IObjectListing<WorldObjectId,IWorldObject> getWorldObjectListing();
	
	/** Clear all registries
	 */
	public void clear();
	
	
	/** Apply world object event
	 * 
	 * @param event either {@link WorldObjectFirstEncounteredEvent}, {@link WorldObjectUpdatedEvent} or {@link WorldObjectDestroyedEvent}
	 */
	public void applyWorldObjectEvent( IWorldChangeEvent event );
	
	/** Register object
	 */
	public void registerObject( IWorldObject object, SimulationTime time );
	
	/** Notify that object has been updated
	 */
	public void notifyObjectUpdated( IWorldObject object, SimulationTime time );
	
	/** Forget object
	 */
	public void forgetObject( IWorldObject object, SimulationTime time );
}