package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;

/** Registry of viewable object beliefs.
 * 
 * Adds tracking of beliefs.
 * 
 * @author Paletz
 */
public interface IViewableObjectBeliefRegistry extends IViewableObjectRegistry{
	
	/** Get listing of beliefs that are either proven (object being visible) or not contradicted
	 * 
	 * @return listing of beliefs that are either proven (object being visible) or not contradicted
	 */
	IObjectListing<WorldObjectId, IViewableObjectBelief> getPlausibleBeliefs();
}
