package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry;

import java.util.Map;

/** Object listing interface
 * 
 * @author Paletz
 *
 * @param <TObject> common denominator type of all listed objects
 * @param <TId> ID distinguishing individual objects
 */
public interface IObjectListing<TId,TObject> {

	/** Get immutable map class->(ID->Object) representation of the object listings.
	 * 
	 * @return immutable map class->(ID->Object) representation of the object listings.
	 */
	Map<Class<? extends TObject>, Map<TId, TObject>> getClassGroupedMap();
	
	/** Get immutable map ID->Object of objects that are instances of the passed class.
 	 * 
	 * @param filterClass class that the returned objects must be instance of
	 * @return immutable map ID->Object of objects that are instances of the passed class
	 */
	<TFilterClass extends TObject> Map<TId, TFilterClass> filterByClass( Class<TFilterClass> filterClass );
	
	/** Get immutable map ID->Object representation of the object listings.
	 * 
	 * @return immutable map ID->Object representation of the object listings.
	 */
	 Map<TId, TObject> getMap();
	
	/** Get object by ID
	 * 
	 * @param id object's ID
	 * @return object with given ID or null
	 */
	TObject getById( TId id );
	
	/** Get object by ID
	 * 
	 * @param type object's type
	 * @param id object's ID
	 * @return object with given ID or null
	 * @throws ClassCastException if an object with given ID exists but has wrong type
	 */
	 <TTypedObject extends TObject> TTypedObject getById( Class<TTypedObject> type, TId id );
}
