package cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.player;

import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds.IFoggyReference;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.pawn.IPawn;


/** Player soul
 * 
 * Player soul exists independently of player's body, such as when player dies and respawns in a new body few moments later.
 * 
 * @author Paletz
 */
public interface IPlayer extends IViewable {
	
	/** Get primary pawn
	 * 
	 * @return primary pawn or null if disembodied
	 */
	IFoggyReference<? extends IPawn> getPrimaryPawn();
	
	/** Tell whether the player is this bot
	 *
	 * @return true if the player is this bot
	 */
	boolean isSelf();
}
