package cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.ds;

/** A foggy reference
 * 
 * Reference to an object that may not be visible.
 * Can represent a situation where the reference is visible but the referenced object is not such as a dog on a leash held by a person standing behind corner.
 * 
 * @author Paletz
 *
 */
public interface IFoggyReference<TReference> {

	/** Get referenced object
	 * 
	 * It is an error to get() a hidden reference.
	 * 
	 * @return referenced object
	 */
	TReference getNotHidden();
	
	/** Get referenced object or null if it is hidden
	 * 
	 * @return referenced object or null if it is hidden
	 */
	TReference getHiddenAsNull();
	
	/** Tell if referenced object is hidden
	 *  
	 * @return false if reference is null or the referenced object is replicated, true if the referenced object is not replicated
	 */
	boolean isHidden();
	
	/** Tell if an object is referenced
	 * 
	 * @return true if not null or is hidden
	 */
	boolean isSet();
}
