package cz.cuni.amis.pogamut.emohawk.communication.worldView;

import java.util.ConcurrentModificationException;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.eventBus.IListenerRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IObjectListing;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.worldObject.IViewableObjectBelief;

/** Historic world view
 * 
 * This interface is pure since doesn't include clutter from {@link ILockableVisionWorldView}.
 * 
 * @author Paletz
 */
public interface IPureHistoricWorldView {
	
	/** Get listing of all world objects that were observed so far
	 * 
	 * @return listing of all world objects that were observed so far
	 */
	IObjectListing<WorldObjectId, IWorldObject> getSeenObjects();

	/** Get listing of all currently visible world objects
	 * 
	 * @return listing of all currently visible world objects
	 */
	IObjectListing<WorldObjectId, IViewable> getVisibleObjects();
	
	/** Get listing of all plausible (not contradicted) beliefs
	 * <p>
	 * Includes currently visible objects.
	 * </p>
	 * @return listing of all plausible (not contradicted) beliefs 
	 */
	IObjectListing<WorldObjectId, IViewableObjectBelief> getPlausibleBeliefs();
	
	
	/** Get duration of short term memory
	 * 
	 * Sightings are retained at least for this duration. 
	 * 
	 * @return duration of short term memory in seconds
	 */
	double getShortTermMemoryDuration();
	
	/** Set duration of short term memory
	 * 
	 * Sightings are retained at least for this duration. 
	 * 
	 * @param durationSeconds duration of short term memory
	 */
	void setShortTermMemoryDuration( double durationSeconds );
	
	
	
	/** Contradict belief
	 * 
	 * Mark a belief contradicted, i.e. known to not be true.
	 * <p/>
	 * This can modify plausible world object belief listing ({@link #getPlausibleBeliefs()}) and 
	 * cause {@link ConcurrentModificationException} if the listing is being iterated at the same time.
	 * 
	 * @param belief belief to contradict
	 */
	void contradict( IViewableObjectBelief belief );
	
	
	/** Access events fired on world view
	 * 
	 * @return listener registry
	 */
	IListenerRegistry accessEvents();
}
