package cz.cuni.amis.pogamut.emohawk.communication.stream;

import java.util.LinkedList;


/** Stream buffer
 * 
 * Implements input and output stream. Data sent to input is buffered and available on output FIFO.
 * 
 * @author Paletz
 */
public class StreamBuffer implements IInputStream, IOutputStream {

	protected LinkedList<Object> data;
	
	public StreamBuffer() {
		data = new LinkedList<Object>();
	}
	
	@Override
	public void writeInt(int value) {
		data.add( new Integer(value) );
	}

	@Override
	public void writeFloat(float value) {
		data.add( new Float(value) );
	}
	
	@Override
	public void writeBool(boolean value) {
		data.add( new Boolean(value) );
	}

	@Override
	public void writeString(String value) {
		data.add( value );
	}
	
	@Override
	public PayloadType tellNext() {
		if ( data.isEmpty() ) {
			return PayloadType.PAYLOAD_TYPE_EOF;
		} else {
			return tellType( data.iterator().next() );
		}
	}
	
	@Override
	public int readInt() {
		return (Integer) data.pop();
	}

	@Override
	public float readFloat() {
		return (Float) data.pop();
	}

	@Override
	public boolean readBool() {
		return (Boolean) data.pop();
	}

	@Override
	public String readString() {
		return (String) data.pop();
	}
	
	/** Clear any buffered data
	 */
	public void clear() {
		data.clear();
	}
	
	/** Clone
	 */
	@Override
	public StreamBuffer clone() {
		StreamBuffer retval = new StreamBuffer();
		retval.data = new LinkedList<Object>( data );
		return retval;
	}
	
	protected PayloadType tellType( Object payload ) {
		if ( payload instanceof Integer ) {
			return PayloadType.PAYLOAD_TYPE_INT;
		} else if ( payload instanceof Float ) {
			return PayloadType.PAYLOAD_TYPE_FLOAT;
		} else if ( payload instanceof Boolean ) {
			return PayloadType.PAYLOAD_TYPE_BOOL;
		} else if ( payload instanceof String ) {
			return PayloadType.PAYLOAD_TYPE_STRING;
		} else {
			throw new AssertionError( "Unexpected value." );
		}
	}
}
