package cz.cuni.amis.pogamut.emohawk.communication.stream;


/** Output stream interface
 *  
 * Output stream of unreal primitives.
 */
public interface IOutputStream {
	
	/** Write integer primitive
	 *  
	 * @param value integer to write
	 */
	void writeInt( int value );

	/** Write float primitive
	 *  
	 * @param value float to write
	 */
	void writeFloat( float value );

	/** Write boolean primitive
	 *  
	 * @param value boolean to write
	 */
	void writeBool( boolean value );

	/** Write string primitive
	 *  
	 * @param value string to write
	 */
	void writeString( String value );
}
