package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

/** Input stream capable of receiving object references
 */
public interface IObjectInputStream extends IInputStream {

	/** Read object reference primitive
	 * 
	 * Results in error if next primitive is not an object reference. See also tellNext().
	 * @return object
	 */
	IObjectReplica readObjectRef();
	
	/** Read object reference primitive but keep it in stream
	 * 
	 * Results in error if next primitive is not an object reference. See also tellNext().
	 * @return object
	 */
	IObjectReplica peekObjectRef();
}