package cz.cuni.amis.pogamut.emohawk.communication.messages.stream;

import java.util.ArrayList;

import cz.cuni.amis.pogamut.emohawk.communication.stream.EncodedObjectRef;
import cz.cuni.amis.pogamut.emohawk.communication.stream.EncodedObjectStreamBuffer;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IEncodedObjectInputStream;


/** Info message stream payload
 * 
 * @author Paletz
 */
public class InfoMessageStreamPayload implements IStreamPayloadCarrierInfoMessage {

	protected ArrayList<Object> primitives;
	
	public InfoMessageStreamPayload() {
		primitives = new ArrayList<Object>();
	}
	
	@Override
	public IEncodedObjectInputStream getPayloadStream() {
		EncodedObjectStreamBuffer buffer = new EncodedObjectStreamBuffer();
		for ( int i=0; i<primitives.size(); ++i ) {
			Object primitive = primitives.get(i);
			
			if ( primitive instanceof Integer ) {
				buffer.writeInt( (Integer) primitive );
			} else if ( primitive instanceof Boolean ) {
				buffer.writeBool( (Boolean) primitive );
			} else if ( primitive instanceof Float ) {
				buffer.writeFloat( (Float) primitive );
			} else if ( primitive instanceof String ) {
				buffer.writeString( (String) primitive );
			} else if ( primitive instanceof EncodedObjectRef ) {
				buffer.writeObjectRef( ((EncodedObjectRef) primitive).getValue() );
			} else if ( primitive == null ) {
				throw new RuntimeException( "Missing primitive with index "+i+"." );
			} else {
				throw new AssertionError( "Unexpected primitive." );
			}
		}
		return buffer;
	}
	
	@Override
	public void addPrimitive(Object primitive, int index) {
		assert(
			primitive instanceof Integer
			||
			primitive instanceof Boolean
			||
			primitive instanceof Float
			||
			primitive instanceof String
			||
			primitive instanceof EncodedObjectRef 
		);
		while ( primitives.size() <= index ) {
			primitives.add( null );
		}
		primitives.set( index,  primitive );
	}
}