package cz.cuni.amis.pogamut.emohawk.communication.messages.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;

/** Object is no longer replicated
 * 
 * The replication ID is freed and can be used by another object.
 * @author Paletz
 */
public class ObjectTearOff extends InfoMessage implements IReplicationEvent {

	protected long simTime;
	protected int replicationIndex;
	
	public ObjectTearOff() {
		simTime = 0;
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime() {
		return simTime;
	}

	/** Get the replication index
	 * 
	 * @return the replication index	 
	 */
	public int getReplicationIndex() {
		return replicationIndex;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationIndex(int replicationIndex) {
		this.replicationIndex = replicationIndex;
	}
}
