package cz.cuni.amis.pogamut.emohawk.bot.impl;

import java.util.Random;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.action.Activeness;
import cz.cuni.amis.pogamut.emohawk.agent.game.EhGame;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon.Emoticons;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.EmohawkNavigation;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.Steering;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IHistoricWorldView;
import cz.cuni.amis.pogamut.unreal.agent.navigation.IUnrealPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004PathRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004PathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.KefikRunner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.loquenavigator.LoqueNavigator;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.Communication;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotLogicController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.PasswordReply;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Trace;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TraceResponse;

/** Emohawk bot controller
 * 
 * @author Paletz
 */
public abstract class EmohawkBotController<BOT extends UT2004Bot<?,?,?> > extends UT2004BotLogicController<BOT> {
	
	protected EmohawkBotBrain brain;
	
	protected Random random = new Random(System.currentTimeMillis());
	
	@Deprecated
	protected Game ut2004game; // TODO switch to emohawk game
	protected EhGame game; // TODO doesn't track map name yet
	
	@Deprecated
	protected UT2004AgentInfo ut2004AgentInfo; // TODO remove when legacy navigation modules get updated 
	protected EhAgentInfo agentInfo;
	
	@Deprecated
	protected AgentConfig config; // TODO inspect
	
	protected Raycasting raycasting;
	
	protected AdvancedLocomotion movement;
	
	protected Communication comm;
	
	protected UT2004PathExecutor<ILocated> pathExecutor = null;
	
    protected IPathPlanner<ILocated> pathPlanner = null;
        
    protected NavigationGraphBuilder navGraphBuilder;
    
    protected FloydWarshallMap fwMap;
    
    protected Steering steering;
	
    protected EmohawkNavigation navigation;
           
    protected AnnotationListenerRegistrator annotationListenerRegistrator;
    
    protected IAct act;
    
	/** Emoticons
	 * 
	 * @FIXME This is not working since it depends on removed PlayerMessages. To make it worse pawns do not send emoticons yet.
	 */
	@Deprecated
	protected Emoticons emoticons; // TODO reimplement
	
	protected Activeness activeness;
	
	
	// MODULE GETTERS
	
	
	public Random getRandom() {
		return random;
	}
	
	/** Get module specialized on general info about the agent whereabouts.
	 * 
	 * @deprecated functionality moved to emohawk agent info
	 */
	@Deprecated
	public UT2004AgentInfo getUtAgentInfo() {
		return ut2004AgentInfo;
	}
	
	/** Get agent info module
	 * <p>
	 * Provides access to bot's pawn etc.
	 * </p>
	 */
	public EhAgentInfo getAgentInfo() {
		return agentInfo;
	}
	
	/** Get memory module specialized on the agent's configuration inside <strike>UT2004</strike> Emohawk - name, vision time, manual spawn, cheats (if enabled at GB2004).
	 *
	 * @deprecated Not tested in context of Emohawk, expect bugs.
	 */
	@Deprecated
	public AgentConfig getConfig() {
		return config;
	}

	/** Get support for creating rays used for raycasting (see {@link AutoTraceRay} that is being utilized).
	 * <p>
	 * WARNING: As of January 2014 the GameBotsUDK raytracing is only partially tested.
	 * Tested parts ({@link Trace} and {@link TraceResponse}) were incredibly buggy (now fixed).
	 * Raycasting uses untested parts :(
	 * </p> 
	 */
	public Raycasting getRaycasting() {
		return raycasting;
	}

	/** Get movement module.
	 */
	public AdvancedLocomotion getMovement() {
		return movement;
	}
	
	/** Get memory module specialized on general info about the ut2004game - ut2004game type, time limit, frag limit, etc.
	 * 
	 * @deprecated functionality moved to emohawk {@link #game}
	 */
	@Deprecated
	public Game getUtGame() {
		return ut2004game;
	}
	
	/** Get game rules and state module
	 */
	public EhGame getGame() {
		return game;
	}
	
	/** Get communication module
	 * <p>
	 * Allows for speaking and listening.
	 * </p>
	 */
	public Communication getComm() {
		return comm;
	}

	/** Get navigation graph builder
	 * <p>
	 * Allows for modification of navigation graph exported from the game.
	 * </p> 
	 */
	public NavigationGraphBuilder getNavGraphBuilder() {
		return navGraphBuilder;
	}
	
	/** Get path executor
	 * <p>
	 * Path executor is used for following a path in the environment.
	 * </p>
     */
	public IUnrealPathExecutor<ILocated> getPathExecutor() {
		return pathExecutor;
	}

    /** Get path planner.
     * <p>
     * Path planner used to compute the path (consisting of navigation points) inside the map.
     * </p>
     */
	public IPathPlanner<ILocated> getPathPlanner() {
		return pathPlanner;
	}

    /** Get navigation graph builder
     * <p>
     * Navigation graph builder may be used to modify the navigation graph exported from the map (level).
     * </p>
     */
	public IHistoricWorldView getWorldView() {
		return (IHistoricWorldView) super.getWorldView();
	}
	
    /** Get Floyd-Warshall map
     * <p>
     * Floyd-Warshall map of the navigation graph; can be used to find shortest path between navigation points.
     * </p>
     * @see {@link EmohawkNavigation#getNearestNavPoint(ILocated)}
     */
	public FloydWarshallMap getFwMap() {
		return fwMap;
	}
	
    /** Get navigation module
     * <p> 
     * Navigation module can be used for bot navigation within the environment.
     * </p> 
     */
	public EmohawkNavigation getNavigation() {
		return navigation;
	}
	
	/** Get Action performing module
	 * <p>
	 * Allows the bot to request an action to be performed.
	 * </p>
	 */
	public Activeness getActiveness() {
		return activeness;
	}
	
	
	// METHODS
	
	
    @Override
	public void initializeController(BOT bot) {    	
		super.initializeController(bot);
		initializeModules();
	}
	
	/**
	 * Initializes memory/command modules of the bot.
	 * 
	 * @param bot
	 */
	protected void initializeModules() {
		act = getAct();
		ut2004game = makeUtGame();
		game = makeGame();
		ut2004AgentInfo = makeUT2004AgentInfo();
		config = makeAgentConfig();
		raycasting = makeRaycasting();
		movement = makeAdvancedLocomotion();
		comm = makeCommunication();
		navGraphBuilder = makeNavBuilder();
        emoticons = makeEmoticons();
        steering = makeSteering();
        agentInfo = makeAgentInfo();
        activeness = makeActiveness();
        
		pathPlanner = new UT2004AStarPathPlanner(bot);
		fwMap = new FloydWarshallMap(bot);
		pathExecutor = new UT2004PathExecutor<ILocated>(
       		bot,
       		ut2004AgentInfo,
       		movement,
       		new LoqueNavigator<ILocated>(
       			bot,
       			ut2004AgentInfo,
       			movement,
       			makeRunner(), 
       			bot.getLog()
       		)
       	);
		navigation = new EmohawkNavigation(bot, steering, fwMap);
		
        brain = makeBrain();
		annotationListenerRegistrator = new AnnotationListenerRegistrator( brain, getWorldView(), bot.getLogger().getCategory("Listeners") );
		annotationListenerRegistrator.addListeners();

	}
	
	@Override
	public PasswordReply getPassword() {
		return new PasswordReply( brain.getPassword() );
	}
	
	@Override
	public Initialize getInitializeCommand() {
		return brain.getInitializeCommand();
	}
	
	@Override
	public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
		super.botInitialized(gameInfo, currentConfig, init);
		brain.botInitialized();
	}
	

	@Override
	public void botFirstSpawn(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
		super.botFirstSpawn(gameInfo, currentConfig, init, self);
		brain.botFirstSpawn();
	}
    
	@Override
	public void beforeFirstLogic() {
		super.beforeFirstLogic();
		brain.beforeFirstLogic();
	}
	
	@Override
	public void logic() {
		super.logic();
		brain.logic();
	}
	
	@Override
	public void botKilled(BotKilled event) {
		super.botKilled(event);
		brain.botKilled(event);
	}

	@Override
	public void botShutdown() {
		super.botShutdown();
		brain.botShutdown();
	}
	
	
	// MODULE CONSTRUCTORS
	
	
	/** Create bot brain
	 * 
	 * @return bot brain, the top-level artificial inteligence 
	 */
	protected abstract EmohawkBotBrain makeBrain();

	
	protected Game makeUtGame() {
		return new Game(bot);
	}
	
	protected EhGame makeGame() {
		return new EhGame( getWorldView() );
	}
	
	protected UT2004AgentInfo makeUT2004AgentInfo() {
		return new UT2004AgentInfo(bot, ut2004game);
	}
		
	protected AgentConfig makeAgentConfig() {
		return new AgentConfig(bot);
	}
	
	protected Raycasting makeRaycasting() {
		return new Raycasting(bot);
	}
	
	protected AdvancedLocomotion makeAdvancedLocomotion() {
		return new AdvancedLocomotion(getBot(), getBot().getLogger().getCategory("Move"));
	}
	
	protected Communication makeCommunication() {
		return new Communication(getBot(), getBot().getLogger().getCategory("Communicaton"));
	}
		
	protected NavigationGraphBuilder makeNavBuilder() {
		return new NavigationGraphBuilder( bot );
	}
	
	protected Emoticons makeEmoticons() {
		return new Emoticons(bot);
	}
	
	protected Steering makeSteering() {
		return new Steering(bot);
	}
	
	protected IUT2004PathRunner makeRunner() {
		return new KefikRunner( bot, ut2004AgentInfo, movement, bot.getLog() );
	}
	
	protected EhAgentInfo makeAgentInfo() {
		return new EhAgentInfo( getWorldView() );
	}
	
	protected Activeness makeActiveness() {
		return new Activeness( act, getWorldView(), agentInfo, getGame(), log );
	}
}
