package cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.emoticon;

/**
 * Represents bot emoticon. Bot emoticon consists from up to three emoticons and
 * background bubble.
 * 
 * @author knight
 */
public class Emoticon {
    /** default bubble for emoticons */
    private static EmoticonBubbleType DEFAULT_BUBBLE = EmoticonBubbleType.BUBBLE_THOUGHT_CENTER;
    /** Left emoticon */
    private EmoticonType leftEmoticon;
    /** Center emoticon */
    private EmoticonType centerEmoticon;
    /** Right emoticon */
    private EmoticonType rightEmoticon;
    /** Bubble of the emoticon */
    private EmoticonBubbleType bubble;
    /**
     * Through this we determine type of the emoticon - double emoticon has to have left and right
     * emoticon type set - emoticonCount will be 2. Single emoticon has to have center emoticon set
     * emoticonCount will be 1, triple emoticon has to have all emoticon types set - 
     * emoticonCount will be 3. EmoticonCount 0 means that there is no emoticon set.
     */
    private int emoticonCount = 0;

    public EmoticonBubbleType getBubble() {
        return bubble;
    }

    public EmoticonType getCenterEmoticon() {
        return centerEmoticon;
    }

    public EmoticonType getLeftEmoticon() {
        return leftEmoticon;
    }

    public EmoticonType getRightEmoticon() {
        return rightEmoticon;
    }

    public int getEmoticonCount() {
        return emoticonCount;
    }
    
    /**
     * Returns all 3 emoticons as currently displayed by you (displayed from LEFT-to-RIGHT).
     * 
     * 0 emoticons displayed: returns []
     * 
     * 1 emoticon displayed: returns [CENTER]
     * 
     * 2 emoticons displayed: returns [LEFT, RIGHT]
     * 
     * 3 emoticons displayed: returns [LEFT, CENTER, RIGHT]
     * 
     * @return array of [left, center, right] emoticon being displayed, NONE emoticons are omitted!
     */
    public EmoticonType[] getEmoticonTypes() {
    	switch(getEmoticonCount()) {
    	case 0:
    		return new EmoticonType[0];
    		
    	case 1:
    		return new EmoticonType[]{getCenterEmoticon()};
    	
    	case 2:
    		return new EmoticonType[]{getLeftEmoticon(), getRightEmoticon()};
    		
    	case 3:
    		return new EmoticonType[]{getLeftEmoticon(), getCenterEmoticon(), getRightEmoticon()};

    	default:
    		throw new RuntimeException("Emoticon returned wrong emoticon count = " + getEmoticonCount() + " !!!");
    	}

    }

    /**
     * Triple emoticon constructor - has to have all three emoticons set.
     * @param leftEmoticon
     * @param centerEmoticon
     * @param rightEmoticon
     * @param bubble
     */
    public Emoticon(EmoticonType leftEmoticon, EmoticonType centerEmoticon, EmoticonType rightEmoticon, EmoticonBubbleType bubble) {
        this.leftEmoticon = leftEmoticon;       
        this.centerEmoticon = centerEmoticon;        
        this.rightEmoticon = rightEmoticon;
        if (leftEmoticon != null && rightEmoticon != null && centerEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE && centerEmoticon != EmoticonType.NONE)
            emoticonCount = 3;
        else if (leftEmoticon != null && rightEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE)
            emoticonCount = 2;
        else if (centerEmoticon != null && centerEmoticon != EmoticonType.NONE)
            emoticonCount = 1;
        this.bubble = bubble;
        if (bubble == null || bubble == EmoticonBubbleType.NONE)
            bubble = DEFAULT_BUBBLE;
    }

    /**
     * Single emoticon constructor - sets center emoticon type.
     * @param centerEmoticon
     * @param bubble
     */
    public Emoticon(EmoticonType centerEmoticon, EmoticonBubbleType bubble) {
        this.centerEmoticon = centerEmoticon;
        if (centerEmoticon != null && centerEmoticon != EmoticonType.NONE)
            emoticonCount = 1;
        this.bubble = bubble;  
        if (bubble == null || bubble == EmoticonBubbleType.NONE)
            bubble = DEFAULT_BUBBLE;
    }

    /**
     * Double emoticon constructor - sets left and right emoticon (only way to display
     * double emoticon).
     * @param leftEmoticon
     * @param rightEmoticon
     * @param bubble
     */
    public Emoticon(EmoticonType leftEmoticon, EmoticonType rightEmoticon, EmoticonBubbleType bubble) {
        this.leftEmoticon = leftEmoticon;
        this.rightEmoticon = rightEmoticon;
        if (leftEmoticon != null && rightEmoticon != null && leftEmoticon != EmoticonType.NONE && rightEmoticon != EmoticonType.NONE)
            emoticonCount = 2;
        this.bubble = bubble;
        if (bubble == null || bubble == EmoticonBubbleType.NONE)
            bubble = DEFAULT_BUBBLE;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Emoticon other = (Emoticon) obj;
        if (this.leftEmoticon != other.leftEmoticon) {
            return false;
        }
        if (this.centerEmoticon != other.centerEmoticon) {
            return false;
        }
        if (this.rightEmoticon != other.rightEmoticon) {
            return false;
        }
        if (this.bubble != other.bubble) {
            return false;
        }
        if (this.emoticonCount != other.emoticonCount) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 11 * hash + (this.leftEmoticon != null ? this.leftEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.centerEmoticon != null ? this.centerEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.rightEmoticon != null ? this.rightEmoticon.hashCode() : 0);
        hash = 11 * hash + (this.bubble != null ? this.bubble.hashCode() : 0);
        hash = 11 * hash + this.emoticonCount;
        return hash;
    }
    
    @Override
    public String toString() {
    	return "Emoticon[left=" + leftEmoticon + ", center=" + centerEmoticon + ", right=" + rightEmoticon + ", bubble=" + bubble + "]";
    }

}
