package cz.cuni.amis.pogamut.emohawk.agent.losChecker;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.listener.IListener;

public interface ILosChecker {

	/** Check whether location is within field of view
	 * 
	 * Does not consider walls etc., just the direction agent is facing.
	 * 
	 * @param location to check
	 */
	boolean isWithinFov( Location location );
	
	/** Request line-of-sight check
	 * 
	 * @param location location to be checked 
	 */
	void requestLosCheck( Location location );
	
	/** Register line-of-sight report listener
	 * 
	 * 
	 * @param listener listener to register
	 */
	void registerLosReportListener( IListener<LosReportEvent> listener );
	
	/** Forget line-of-sight report listener
	 * 
	 * @param listener listener to forget
	 */
	void forgetLosReportListener( IListener<LosReportEvent> listener );
}
