package cz.cuni.amis.pogamut.emohawk.agent.game;

import java.util.Collection;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.game.IGameBelief;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;

/** Emohawk game module
 * 
 * @author Paletz
 */
public class EhGame {

	IPureHistoricWorldView worldView;
	IGameBelief game;
	double time;
	
	/** Constructor
	 * 
	 * @param worldView world view
	 */
	public EhGame( IPureHistoricWorldView worldView ) {
		this.worldView = worldView;
		time = Double.NEGATIVE_INFINITY;
		worldView.accessEvents().addEventListener( BeginMessage.class, beginMessageListener );
		worldView.accessEvents().addEventListener( EndMessage.class, endMessageListener );
	}
	
	/** Dispose
	 */
	public void dispose() {
		worldView.accessEvents().removeEventListener( BeginMessage.class, beginMessageListener );
		worldView.accessEvents().removeEventListener( EndMessage.class, endMessageListener );
	}
	
	/** Get game rules and state belief
	 * 
	 * @return game rules and state belief
	 */
	public IGameBelief getGame() {
		return game;
	}
	
	/** Get current time
	 * 
	 * @return
	 */
	public double getTime() {
		return time;
	}
	
	
	protected final IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>() {
		@Override
		public void notify(BeginMessage event) {
			time = event.getTime();
		}
	};
	
	protected final IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>() {
		@Override
		public void notify(EndMessage event) {
			assert( time == event.getTime() );
			Collection<IGameBelief> games = worldView.getPlausibleBeliefs().filterByClass( IGameBelief.class ).values();
			assert( games.size() == 1 );
			game = games.iterator().next();
		}
	};
}
