package cz.cuni.amis.pogamut.emohawk.agent;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.pawn.IPawnBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.player.IPlayerBelief;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;

/** Emohawk agent info
 * 
 * @author Paletz
 */
public class EhAgentInfo implements ILocated {
	
	IPureHistoricWorldView worldView;
	IPlayerBelief self;
	double time;
	
	/** Constructor
	 * 
	 * @param worldView world view
	 */
	public EhAgentInfo( IPureHistoricWorldView worldView ) {
		this.worldView = worldView;
		time = Double.NEGATIVE_INFINITY;
		worldView.accessEvents().addEventListener( BeginMessage.class, beginMessageListener );
		worldView.accessEvents().addEventListener( EndMessage.class, endMessageListener );
	}
	
	/** Dispose
	 */
	public void dispose() {
		worldView.accessEvents().removeEventListener( BeginMessage.class, beginMessageListener );
		worldView.accessEvents().removeEventListener( EndMessage.class, endMessageListener );
	}
	
	/** Get bot's player object
	 * 
	 * @return bot's player object
	 */
	public IPlayerBelief getPlayer() {
		return self;
	}
	
	/** Get bot's pawn
	 * 
	 * @return bot's pawn, or null if bot is disembodied at the moment
	 */
	public IPawnBelief getPawn() {
		return getPlayer().getPrimaryPawn().getNotHidden();
	}
	
	/** Get current time
	 * 
	 * @return
	 */
	public double getTime() {
		return time;
	}
	
	@Override
	public Location getLocation() {
		if ( getPawn() == null ) {
			return null;
		}
		return getPawn().getLocation();
	}
	
	/** Get distance to pawn
	 * 
	 * @param located object
	 * @return distance to pawn or positive infinity if pawn's or object's location is not defined
	 */
	public double getDistance( ILocated located ) {
		if ( located.getLocation() == null || getPawn() == null || getPawn().getLocation() == null ) {
			return Double.POSITIVE_INFINITY;
		}
		return getPawn().getLocation().getDistance( located.getLocation() );
	}
	
	/** Get nearest navigation point
	 * 
	 * @return nearest navigation point
	 */
	public NavPoint getNearestNavPoint() {
		if (getLocation() == null) return null;
		return DistanceUtils.getNearest(
			worldView.getSeenObjects().filterByClass(NavPoint.class).values(),
			getLocation()
		);
	}
	
	protected final IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>() {
		@Override
		public void notify(BeginMessage event) {
			time = event.getTime();
		}
	};
	
	protected final IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>() {
		@Override
		public void notify(EndMessage event) {
			assert( time == event.getTime() );
			for ( IPlayerBelief player : worldView.getPlausibleBeliefs().filterByClass( IPlayerBelief.class ).values() ) {
				if ( player.isSelf() ) {
					self = player;
					break;
				}
			}
		}
	};
}
