/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.IReplicationEvent;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ReplicationCommit;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.batchClock.ISimulationClock;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectRegistry.IWorldObjectRegistry;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.IWorldObjectUpdater;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.IObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.IReplicaEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaCreatedEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaTornOffEvent;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.event.ReplicaUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.utils.listener.IListener;

public class ReplicationWorldObjectUpdater
implements IWorldObjectUpdater {
    protected ISimulationClock simulationClock;
    protected IObjectReplicationClient objectReplicationClient;
    protected IWorldObjectRegistry worldObjectRegistry;
    protected final IListener<IReplicaEvent> replicaEventListener = new IListener<IReplicaEvent>(){

        public void notify(IReplicaEvent event) {
            if (event.getReplica() instanceof IWorldObject) {
                IWorldObject worldObject = (IWorldObject)event.getReplica();
                if (event instanceof ReplicaCreatedEvent) {
                    ReplicationWorldObjectUpdater.this.worldObjectRegistry.registerObject(worldObject, ReplicationWorldObjectUpdater.this.simulationClock.getTime());
                } else if (event instanceof ReplicaUpdatedEvent) {
                    ReplicationWorldObjectUpdater.this.worldObjectRegistry.notifyObjectUpdated(worldObject, ReplicationWorldObjectUpdater.this.simulationClock.getTime());
                } else if (event instanceof ReplicaTornOffEvent) {
                    ReplicationWorldObjectUpdater.this.worldObjectRegistry.forgetObject(worldObject, ReplicationWorldObjectUpdater.this.simulationClock.getTime());
                } else {
                    throw new AssertionError((Object)"Unexpected event.");
                }
            }
        }
    };

    @Inject
    public ReplicationWorldObjectUpdater(IObjectReplicationClient objectReplicationClient) {
        this.objectReplicationClient = objectReplicationClient;
        objectReplicationClient.registerReplicaEventListener(this.replicaEventListener);
    }

    @Override
    public void applyWorldObjectUpdate(IWorldChangeEvent event) {
        if (event instanceof EndMessage) {
            this.objectReplicationClient.applyReplicationEvent(new ReplicationCommit(event.getSimTime()));
        }
        if (event instanceof IReplicationEvent) {
            this.objectReplicationClient.applyReplicationEvent((IReplicationEvent)event);
        }
        if (event instanceof BeginMessage || event instanceof EndMessage) {
            this.simulationClock.applyWorldChange(event);
        }
    }

    @Override
    public void initWorldObjectRegistry(IWorldObjectRegistry worldObjectRegistry) {
        this.worldObjectRegistry = worldObjectRegistry;
    }

    @Override
    public void initSimulationClock(ISimulationClock simulationClock) {
        this.simulationClock = simulationClock;
        this.objectReplicationClient.initSimulationClock(simulationClock);
    }
}

