/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.stream;

import cz.cuni.amis.pogamut.emohawk.communication.stream.IObjectInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IOutputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.replication.replica.iface.object.IObjectReplica;

public class PrimitiveTools {
    public static <Primitive> Primitive readPrimitive(Class<Primitive> primitiveClass, IObjectInputStream stream) {
        if (primitiveClass == Integer.class) {
            return (Primitive)new Integer(stream.readInt());
        }
        if (primitiveClass == Boolean.class) {
            return (Primitive)new Boolean(stream.readBool());
        }
        if (primitiveClass == String.class) {
            return (Primitive)stream.readString();
        }
        if (primitiveClass == Float.class) {
            return (Primitive)new Float(stream.readFloat());
        }
        if (IObjectReplica.class.isAssignableFrom(primitiveClass)) {
            return (Primitive)stream.readObjectRef();
        }
        throw new AssertionError((Object)("Unexpected primitive class " + primitiveClass));
    }

    public static <Primitive> boolean hasPrimitive(Class<Primitive> primitiveClass, IObjectInputStream stream) {
        if (primitiveClass == Integer.class) {
            return stream.tellNext() == PayloadType.PAYLOAD_TYPE_INT;
        }
        if (primitiveClass == Boolean.class) {
            return stream.tellNext() == PayloadType.PAYLOAD_TYPE_BOOL;
        }
        if (primitiveClass == String.class) {
            return stream.tellNext() == PayloadType.PAYLOAD_TYPE_STRING;
        }
        if (primitiveClass == Float.class) {
            return stream.tellNext() == PayloadType.PAYLOAD_TYPE_FLOAT;
        }
        if (IObjectReplica.class.isAssignableFrom(primitiveClass)) {
            return stream.tellNext() == PayloadType.PAYLOAD_TYPE_OBJECT_REF && primitiveClass.isInstance(stream.peekObjectRef());
        }
        throw new AssertionError((Object)("Unexpected primitive class " + primitiveClass));
    }

    public static void writePrimitive(Object primitive, IOutputStream stream) {
        if (primitive instanceof Integer) {
            stream.writeInt((Integer)primitive);
        } else if (primitive instanceof Boolean) {
            stream.writeBool((Boolean)primitive);
        } else if (primitive instanceof String) {
            stream.writeString((String)primitive);
        } else if (primitive instanceof Float) {
            stream.writeFloat(((Float)primitive).floatValue());
        } else {
            if (primitive instanceof IObjectReplica) {
                throw new AssertionError((Object)"Object references not supported.");
            }
            throw new AssertionError((Object)("Unexpected primitive class " + primitive.getClass()));
        }
    }
}

