/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication.messages.action;

import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.CommandStreamPayload;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierCommand;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;

public class PerformAction
extends CommandMessage
implements IStreamPayloadCarrierCommand {
    protected int performerIndex;
    protected int actionIndex;
    protected int userRequestId;
    protected CommandStreamPayload streamPayload;

    public PerformAction(int performerIndex, int actionIndex, int userRequestId) {
        this.performerIndex = performerIndex;
        this.actionIndex = actionIndex;
        this.userRequestId = userRequestId;
        this.streamPayload = new CommandStreamPayload();
    }

    public PerformAction() {
        this(-1, -1, -1);
    }

    public PerformAction(PerformAction original) {
        this(original.performerIndex, original.actionIndex, original.userRequestId);
        this.streamPayload = original.streamPayload.clone();
    }

    @Override
    public void writeInt(int value) {
        this.streamPayload.writeInt(value);
    }

    @Override
    public void writeFloat(float value) {
        this.streamPayload.writeFloat(value);
    }

    @Override
    public void writeBool(boolean value) {
        this.streamPayload.writeBool(value);
    }

    @Override
    public void writeString(String value) {
        this.streamPayload.writeString(value);
    }

    @Override
    public IInputStream getPayload() {
        return this.streamPayload.getPayload();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SACRQ ");
        builder.append("{Performer " + this.performerIndex + "} ");
        builder.append("{Action " + this.actionIndex + "} ");
        builder.append("{UserRequestId " + this.userRequestId + "}");
        builder.append(this.streamPayload.toParameterText());
        return builder.toString();
    }
}

