/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.communication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.emohawk.agent.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.messages.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.messages.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.messages.stream.IStreamPayloadCarrierInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.EncodedObjectRef;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EmohawkYylex
extends Yylex {
    protected static final Pattern PRIMITIVE_STREAM_PARAMETER_PATTERN = Pattern.compile("([IBFSR]PKT)([0-9]+)");

    protected InfoMessage tryParsingUnprocessedMessage(String messageName) {
        if (messageName.equals("ROB")) {
            return new ObjectReplication();
        }
        if (messageName.equals("TOB")) {
            return new ObjectTearOff();
        }
        if (messageName.equals("UOB")) {
            return new ObjectUpdate();
        }
        if (messageName.equals("ACTRSLT")) {
            return new ActionResult();
        }
        return super.tryParsingUnprocessedMessage(messageName);
    }

    protected boolean tryParsingUnprocessedMessageParameter(String paramName, String wholeParamText) {
        if (this.actObj instanceof ObjectReplication) {
            if (paramName.equals("Index")) {
                ((ObjectReplication)this.actObj).setReplicationIndex(this.integerValue(wholeParamText));
                return true;
            }
            if (paramName.equals("Class")) {
                ((ObjectReplication)this.actObj).setObjectClass(this.stringValue(wholeParamText));
                return true;
            }
            return false;
        }
        if (this.actObj instanceof ObjectTearOff) {
            if (paramName.equals("Index")) {
                ((ObjectTearOff)this.actObj).setReplicationIndex(this.integerValue(wholeParamText));
                return true;
            }
            return false;
        }
        if (this.actObj instanceof ObjectUpdate) {
            if (paramName.equals("Index")) {
                ((ObjectUpdate)this.actObj).setReplicationIndex(this.integerValue(wholeParamText));
                return true;
            }
            return this.tryParsingUnprocessedMessageStreamPrimitive(paramName, wholeParamText);
        }
        if (this.actObj instanceof ActionResult) {
            if (paramName.equals("Message")) {
                ((ActionResult)this.actObj).setMessage(this.stringValue(wholeParamText));
                return true;
            }
            if (paramName.equals("Major")) {
                ((ActionResult)this.actObj).setMajor(MajorActionResult.values()[this.integerValue(wholeParamText)]);
                return true;
            }
            if (paramName.equals("Minor")) {
                ((ActionResult)this.actObj).setMinor(this.integerValue(wholeParamText));
                return true;
            }
            if (paramName.equals("UsrRqId")) {
                ((ActionResult)this.actObj).setUserRequestId(this.integerValue(wholeParamText));
                return true;
            }
            return this.tryParsingUnprocessedMessageStreamPrimitive(paramName, wholeParamText);
        }
        return super.tryParsingUnprocessedMessageParameter(paramName, wholeParamText);
    }

    protected boolean tryParsingUnprocessedMessageStreamPrimitive(String paramName, String wholeParamText) {
        Matcher primitiveParameterNameMatcher = PRIMITIVE_STREAM_PARAMETER_PATTERN.matcher(paramName);
        if (!primitiveParameterNameMatcher.matches()) {
            return false;
        }
        String label = primitiveParameterNameMatcher.group(1);
        int index = Integer.parseInt(primitiveParameterNameMatcher.group(2));
        IStreamPayloadCarrierInfoMessage embeddedPrimitiveStreamMessage = (IStreamPayloadCarrierInfoMessage)this.actObj;
        if (label.equals("IPKT")) {
            embeddedPrimitiveStreamMessage.addPrimitive(this.integerValue(wholeParamText), index);
            return true;
        }
        if (label.equals("BPKT")) {
            embeddedPrimitiveStreamMessage.addPrimitive(this.booleanValue(wholeParamText), index);
            return true;
        }
        if (label.equals("FPKT")) {
            embeddedPrimitiveStreamMessage.addPrimitive(Float.valueOf(this.floatValue(wholeParamText)), index);
            return true;
        }
        if (label.equals("SPKT")) {
            embeddedPrimitiveStreamMessage.addPrimitive(this.stringValue(wholeParamText), index);
            return true;
        }
        if (label.equals("RPKT")) {
            embeddedPrimitiveStreamMessage.addPrimitive(new EncodedObjectRef(this.intValue(wholeParamText)), index);
            return true;
        }
        throw new AssertionError((Object)"Primitive stream parameter pattern shouldn't have matched the param name.");
    }
}

