/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation;

import SteeringProperties.ObstacleAvoidanceProperties;
import SteeringProperties.PathFollowingProperties;
import SteeringProperties.PeopleAvoidanceProperties;
import SteeringProperties.SteeringProperties;
import cz.cuni.amis.pogamut.base.agent.navigation.IPathFuture;
import cz.cuni.amis.pogamut.base.agent.navigation.impl.PrecomputedPathFuture;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.emohawk.agent.sensomotoric.navigation.Steering;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Stop;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class EmohawkNavigation {
    protected static final int NEW_PATH_DISTANCE_THRESHOLD = 40;
    protected static final int ARRIVED_AT_LOCATION_XY_THRESHOLD = 50;
    protected static final int ARRIVED_AT_LOCATION_Z_THRESHOLD = 100;
    protected static final double PLAYER_DISTANCE_TRASHOLD = 600.0;
    public static final double AT_PLAYER = 150.0;
    public static final double AT_LOCATION = 150.0;
    protected LogCategory log;
    private Steering steering;
    protected FloydWarshallMap fwMap;
    protected UT2004Bot<?, ?, ?> bot;
    protected IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            EmohawkNavigation.this.navigate();
        }
    };
    protected ILocated lastTarget = null;
    protected Player lastTargetPlayer = null;
    protected ILocated currentTarget = null;
    protected Player currentTargetPlayer = null;
    protected NavPoint fromNavPoint;
    protected NavPoint toNavPoint;
    protected IPathFuture<ILocated> currentFuturePath;
    protected boolean navigating = false;
    protected boolean runningStraightToPlayer = false;
    protected Location runningStraightToPlayerFailedAt = null;

    public EmohawkNavigation(UT2004Bot<?, ?, ?> bot, Steering steering, FloydWarshallMap fwMap) {
        this.log = bot.getLogger().getCategory(this.getClass().getSimpleName());
        this.bot = bot;
        this.steering = steering;
        this.fwMap = fwMap;
        this.initListeners();
    }

    private void initListeners() {
        this.bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
    }

    public boolean isNavigating() {
        return this.navigating;
    }

    public void setFocus(ILocated located) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    public void stopNavigation() {
        this.reset(true);
        this.bot.getAct().act((CommandMessage)new Stop());
    }

    public void navigate(ILocated target) {
        if (target == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL target!");
            }
            this.stopNavigation();
            return;
        }
        if (target instanceof Player) {
            this.navigate((Player)target);
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == target || this.currentTarget.getLocation().equals((Object)target.getLocation())) {
                return;
            }
            this.reset(false);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start navigating to: " + target);
        }
        this.currentTarget = target;
        this.startNavigate();
    }

    public void navigate(Player player) {
        if (player == null) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning("Cannot navigate to NULL player!");
            }
            return;
        }
        if (this.navigating) {
            if (this.currentTarget == player) {
                return;
            }
            this.reset(false);
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Start pursuing: " + player);
        }
        this.currentTarget = player.getLocation();
        this.currentTargetPlayer = player;
        this.startNavigate();
    }

    public NavPoint getNearestNavPoint(ILocated location) {
        if (location == null) {
            return null;
        }
        if (location instanceof NavPoint) {
            return (NavPoint)location;
        }
        if (location instanceof Item && ((Item)location).getNavPoint() != null) {
            return ((Item)location).getNavPoint();
        }
        return (NavPoint)DistanceUtils.getNearest(this.bot.getWorldView().getAll(NavPoint.class).values(), (ILocated)location);
    }

    public List<ILocated> getCurrentPathCopy() {
        ArrayList<ILocated> result = new ArrayList<ILocated>();
        if (this.currentFuturePath != null) {
            result.addAll(this.currentFuturePath.get());
        }
        return result;
    }

    public List<? extends ILocated> getCurrentPathDirect() {
        if (this.currentFuturePath != null) {
            return this.currentFuturePath.get();
        }
        return null;
    }

    public ILocated getCurrentTarget() {
        return this.currentTarget;
    }

    public Player getCurrentTargetPlayer() {
        if (this.currentTarget instanceof Player) {
            return (Player)this.currentTarget;
        }
        return null;
    }

    public NavPoint getCurrentTargetNavPoint() {
        if (this.currentTarget instanceof NavPoint) {
            return (NavPoint)this.currentTarget;
        }
        return null;
    }

    public ILocated getLastTarget() {
        return this.lastTarget;
    }

    public NavPoint getLastTargetPlayer() {
        if (this.lastTarget instanceof Player) {
            return (NavPoint)this.lastTarget;
        }
        return null;
    }

    public NavPoint getLastTargetNavPoint() {
        if (this.lastTarget instanceof NavPoint) {
            return (NavPoint)this.lastTarget;
        }
        return null;
    }

    protected void startNavigate() {
        if (!this.navigating) {
            if (this.steering.isNavigating()) {
                this.steering.stopNavigation();
            }
            this.steering.clearAllSteerings();
        }
        this.navigating = true;
        this.navigate();
    }

    protected void navigate() {
        if (!this.navigating) {
            return;
        }
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("NAVIGATING");
        }
        if (this.currentTargetPlayer != null) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Pursuing " + this.currentTargetPlayer);
            }
            this.navigatePlayer();
        } else {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Navigating to " + this.currentTarget);
            }
            this.navigateLocation();
        }
    }

    private void navigateLocation() {
        if (this.steering.isNavigating()) {
            if (this.log != null && this.log.isLoggable(Level.FINE)) {
                this.log.fine("Steering running");
            }
            if (this.atLocation(this.currentTarget)) {
                this.reset(true);
            }
            return;
        }
        this.fromNavPoint = this.getNearestNavPoint((ILocated)this.bot.getLocation());
        this.toNavPoint = this.getNearestNavPoint(this.currentTarget);
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine("Running from " + this.fromNavPoint.getId().getStringId() + " to " + this.toNavPoint.getId().getStringId());
        }
        ArrayList path = new ArrayList();
        path.addAll(this.fwMap.computePath(this.fromNavPoint, this.toNavPoint).get());
        this.currentFuturePath = new PrecomputedPathFuture((Object)this.fromNavPoint, (Object)this.toNavPoint, path);
        if (this.currentFuturePath == null || this.currentFuturePath.get() == null || this.currentFuturePath.get().size() == 0) {
            this.log.warning("NON EXISTING PATH BETWEEN: " + this.fromNavPoint.getId().getStringId() + " -> " + this.toNavPoint.getId().getStringId());
        }
        this.processPathFuture(this.currentFuturePath);
        PathFollowingProperties pathFollowingProperties = new PathFollowingProperties();
        pathFollowingProperties.setBehaviorType(SteeringProperties.BehaviorType.ADVANCED);
        pathFollowingProperties.setTargetLocation(this.currentTarget.getLocation());
        pathFollowingProperties.setPath(this.currentFuturePath);
        this.steering.addPathFollowingSteering(pathFollowingProperties);
        PeopleAvoidanceProperties peopleAvoidanceProperties = new PeopleAvoidanceProperties();
        peopleAvoidanceProperties.setBehaviorType(SteeringProperties.BehaviorType.ADVANCED);
        peopleAvoidanceProperties.setAcceleration(true);
        peopleAvoidanceProperties.setCircumvention(true);
        peopleAvoidanceProperties.setDeceleration(true);
        this.steering.addPeopleAvoidanceSteering(peopleAvoidanceProperties);
        ObstacleAvoidanceProperties obstacleAvoidanceProperties = new ObstacleAvoidanceProperties();
        obstacleAvoidanceProperties.setBehaviorType(SteeringProperties.BehaviorType.ADVANCED);
        this.steering.addObstacleAvoidanceSteering(obstacleAvoidanceProperties);
        this.steering.startNavigation();
    }

    private boolean atLocation(ILocated currentTarget) {
        return this.bot.getLocation().getDistance(currentTarget.getLocation()) < 150.0;
    }

    private void navigatePlayer() {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    protected void processPathFuture(IPathFuture<? extends ILocated> futurePath) {
        List pathList = futurePath.get();
        if (pathList == null) {
            return;
        }
        if (!pathList.isEmpty()) {
            ILocated lastPathElement = (ILocated)pathList.get(pathList.size() - 1);
            if (lastPathElement.getLocation().getDistance(this.currentTarget.getLocation()) > 40.0) {
                this.currentFuturePath.get().add(this.currentTarget);
            }
        } else {
            this.currentFuturePath.get().add(this.currentTarget);
        }
    }

    protected void reset(boolean stopGetBackToNavGraph) {
        if (this.currentTarget != null) {
            this.lastTarget = this.currentTarget;
            this.lastTargetPlayer = this.currentTargetPlayer;
        }
        this.navigating = false;
        this.currentTarget = null;
        this.currentTargetPlayer = null;
        this.fromNavPoint = null;
        this.toNavPoint = null;
        this.currentFuturePath = null;
        this.runningStraightToPlayer = false;
        this.runningStraightToPlayerFailedAt = null;
        this.steering.stopNavigation();
        this.steering.clearAllSteerings();
    }
}

