/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.action;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.emohawk.agent.EhAgentInfo;
import cz.cuni.amis.pogamut.emohawk.agent.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.agent.game.EhGame;
import cz.cuni.amis.pogamut.emohawk.communication.messages.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.messages.action.PerformAction;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IInputStream;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StreamTools;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.IPureHistoricWorldView;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.ontology.action.IAction;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.action.IActionRegistryBelief;
import cz.cuni.amis.pogamut.emohawk.communication.worldView.worldObjectUpdater.historic.sightingMemory.belief.iface.game.IGameBelief;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Activeness {
    public static final int ERROR_INVALID_PERFORMER = 1;
    public static final int ERROR_INVALID_ACTION = 2;
    public static final int ERROR_ACCESS_DENIED = 3;
    public static final double DEFAULT_ACTION_TIMEOUT_PERIOD_SECONDS = 30.0;
    protected IAct act;
    protected IPureHistoricWorldView worldView;
    protected EhAgentInfo agentInfo;
    protected EhGame game;
    protected LogCategory log;
    protected IActionRegistryBelief actionRegistry;
    protected Map<Integer, HandlerRecord> resultHandlers;
    protected int nextUserRequestId;
    protected double timeoutPeriodSeconds;
    protected final IWorldEventListener<ActionResult> onInteractionError = new IWorldEventListener<ActionResult>(){

        public void notify(ActionResult event) {
            Activeness.this.cleanHandlers();
            HandlerRecord handlerRecord = Activeness.this.resultHandlers.get(event.getUserRequestId());
            if (handlerRecord != null) {
                handlerRecord.handler.handle(event.getMajor(), event.getMinor(), event.getMessage());
                if (event.getMajor() == MajorActionResult.IR_SUCCESS || event.getMajor() == MajorActionResult.IR_FAILURE) {
                    Activeness.this.resultHandlers.remove(event.getUserRequestId());
                } else {
                    handlerRecord.timeoutTime = Activeness.this.game.getTime() + Activeness.this.timeoutPeriodSeconds;
                }
            }
        }
    };
    protected final IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            Collection<IGameBelief> games = Activeness.this.worldView.getPlausibleBeliefs().filterByClass(IGameBelief.class).values();
            if (games.size() == 0) {
                return;
            }
            assert (games.size() == 1);
            Activeness.this.actionRegistry = games.iterator().next().getActionRegistry();
        }
    };

    public Activeness(IAct act, IPureHistoricWorldView worldView, EhAgentInfo agentInfo, EhGame game, LogCategory log, double timeoutPeriodSeconds) {
        this.act = act;
        this.worldView = worldView;
        this.agentInfo = agentInfo;
        this.game = game;
        this.timeoutPeriodSeconds = timeoutPeriodSeconds;
        this.log = log;
        this.resultHandlers = new HashMap<Integer, HandlerRecord>();
        this.nextUserRequestId = 1;
        this.timeoutPeriodSeconds = 30.0;
        worldView.accessEvents().addEventListener(ActionResult.class, this.onInteractionError);
        worldView.accessEvents().addEventListener(EndMessage.class, this.endMessageListener);
    }

    public Activeness(IAct act, IPureHistoricWorldView worldView, EhAgentInfo agentInfo, EhGame game, LogCategory log) {
        this(act, worldView, agentInfo, game, log, 30.0);
    }

    public IActionRegistryBelief getActionRegistry() {
        return this.actionRegistry;
    }

    public void requestAction(IAction action, IActionResultHandler resultHandler, IInputStream serializedCustomArguments) {
        this.cleanHandlers();
        int requestId = this.generateRequestId();
        if (resultHandler != null) {
            this.resultHandlers.put(requestId, new HandlerRecord(this.game.getTime() + this.timeoutPeriodSeconds, resultHandler));
        }
        PerformAction command = new PerformAction((int)this.agentInfo.getPawn().getId().getLongId(), (int)action.getId().getLongId(), requestId);
        if (serializedCustomArguments != null) {
            StreamTools.pipeStream(serializedCustomArguments, command);
        }
        this.act.act((CommandMessage)command);
    }

    protected void cleanHandlers() {
        Iterator<HandlerRecord> iterator = this.resultHandlers.values().iterator();
        while (iterator.hasNext()) {
            HandlerRecord record = iterator.next();
            if (!(record.timeoutTime < this.game.getTime())) continue;
            if (this.log != null) {
                this.log.warning("Action result handler timed out.");
            }
            iterator.remove();
        }
    }

    protected int generateRequestId() {
        return this.nextUserRequestId++;
    }

    static class HandlerRecord {
        public double timeoutTime;
        public IActionResultHandler handler;

        public HandlerRecord(double timeoutTime, IActionResultHandler handler) {
            this.timeoutTime = timeoutTime;
            this.handler = handler;
        }
    }
}

