package cz.cuni.amis.pogamut.emohawk.communication.replication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;

/** Object has been replicated
 * 
 * Object value is sent separately. See {@link ObjectUpdate} event.
 * @author Paletz
 */
public class ObjectReplication extends InfoMessage implements IWorldEvent, IWorldChangeEvent {

	protected long simTime;
	protected int replicationIndex;
	protected int replicationGenerationNumber;
	protected String objectClass;
	
	public ObjectReplication() {
		simTime = 0;
	}	
	
	/** Get simTime
	 * 
	 * @return simTime
	 */
	public long getSimTime()
	{
		return simTime;
	}

	/** Get the replication ID
	 * 
	 * @return the replication ID	 
	 */
	public ReplicationId getReplicationId() {
		return new ReplicationId( replicationIndex, replicationGenerationNumber );
	}
	
	/** Get the Unreal script class
	 * 
	 * @return  the Unreal script class
	 */
	public String getObjectClass() {
		return objectClass;
	}
	
	/** Initialization from yylex
	 */
	protected void setSimTime( long value ) {
		simTime = value;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationIndex( int replicationIndex ) {
		this.replicationIndex = replicationIndex;
	}
	
	/** Initialization from yylex
	 */
	public void setReplicationGenerationNumber( int replicationGenerationNumber ) {
		this.replicationGenerationNumber = replicationGenerationNumber;
	}

	/** Initialization from yylex
	 */
	public void setObjectClass(String objectClass) {
		this.objectClass = objectClass;
	}
	
	
}
