package cz.cuni.amis.pogamut.emohawk.communication;

import cz.cuni.amis.pogamut.base.communication.messages.InfoMessage;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.MajorActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.action.ActionResult;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.stream.BoolPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.FloatPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.IntPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.ObjectRefPacketInfoMessage;
import cz.cuni.amis.pogamut.emohawk.communication.stream.StringPacketInfoMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;

/** Emohawk yylex
 * 
 * Extends UT2004 yylex with emohawk messages and commands.
 * @author Paletz
 */
public class EmohawkYylex extends Yylex {
	
	@Override 
	protected InfoMessage tryParsingUnprocessedMessage(String messageName) {
		if ( messageName.equals("ROB") ) {
			return new ObjectReplication();
		} else if ( messageName.equals("TOB") ) {
			return new ObjectTearOff();
		} else if ( messageName.equals("UOB") ) {
			return new ObjectUpdate();
		} else if ( messageName.equals("IPKT") ) {
			return new IntPacketInfoMessage();
		} else if ( messageName.equals("BPKT") ) {
			return new BoolPacketInfoMessage();
		} else if ( messageName.equals("FPKT") ) {
			return new FloatPacketInfoMessage();
		} else if ( messageName.equals("SPKT") ) {
			return new StringPacketInfoMessage();
		} else if ( messageName.equals("ORPKT") ) {
			return new ObjectRefPacketInfoMessage();
		} else if ( messageName.equals("ACTRSLT") ) {
			return new ActionResult();
		} else {
			return super.tryParsingUnprocessedMessage(messageName);
		}
	}
	
	@Override
	protected boolean tryParsingUnprocessedMessageParameter(String paramName, String wholeParamText) {
		if ( actObj instanceof ObjectReplication ) {
			if ( paramName.equals("Index") ) {
				((ObjectReplication) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("GenNum") ) {
				((ObjectReplication) actObj).setReplicationGenerationNumber( integerValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("Class") ) {
				((ObjectReplication) actObj).setObjectClass( stringValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ObjectTearOff ) {
			if ( paramName.equals("Index") ) {
				((ObjectTearOff) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ObjectUpdate ) {
			if ( paramName.equals("Index") ) {
				((ObjectUpdate) actObj).setReplicationIndex( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof IntPacketInfoMessage ) {
			if ( paramName.equals("Value") ) {
				((IntPacketInfoMessage) actObj).setValue( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof FloatPacketInfoMessage ) {
			if ( paramName.equals("Value") ) {
				((FloatPacketInfoMessage) actObj).setValue( floatValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof BoolPacketInfoMessage ) {
			if ( paramName.equals("Value") ) {
				((BoolPacketInfoMessage) actObj).setValue( booleanValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof StringPacketInfoMessage ) {
			if ( paramName.equals("Value") ) {
				((StringPacketInfoMessage) actObj).setValue( stringValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ObjectRefPacketInfoMessage ) {
			if ( paramName.equals("Value") ) {
				((ObjectRefPacketInfoMessage) actObj).setValue( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else if ( actObj instanceof ActionResult ) {
			if ( paramName.equals("Message") ) {
				((ActionResult) actObj).setMessage( stringValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("Major") ) {
				((ActionResult) actObj).setMajor( MajorActionResult.values()[integerValue( wholeParamText )] );
				return true;
			} else if ( paramName.equals("Minor") ) {
				((ActionResult) actObj).setMinor( integerValue( wholeParamText ) );
				return true;
			} else if ( paramName.equals("UsrRqId") ) {
				((ActionResult) actObj).setUserRequestId( integerValue( wholeParamText ) );
				return true;
			}
			return false;
		} else {
			return super.tryParsingUnprocessedMessageParameter(paramName, wholeParamText);
		}
	}
}
