/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive;

import cz.cuni.amis.pogamut.emohawk.agent.module.attribute.AttributeUpstream;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeAccess;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeRawView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.IPrimitiveAttributeView;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.PrimitiveAttributeReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import java.util.Arrays;
import java.util.Iterator;

public class PrimitiveAttributeView<T>
implements IPrimitiveAttributeView<T> {
    protected AttributeRawView<PrimitiveAttributeReplica<T>, T> rawView;
    protected Class<T> primitiveClass;

    public PrimitiveAttributeView(Class<T> primitiveClass, ListMapReplica<IAttributeReplica> attributes, AttributeUpstream upstream) {
        this.primitiveClass = primitiveClass;
        this.rawView = new AttributeRawView(attributes, upstream, new SpecializedClass<PrimitiveAttributeReplica>(PrimitiveAttributeReplica.class, Arrays.asList(SpecializedClass.fromPlain(primitiveClass))));
    }

    @Override
    public T get(String attributeName) {
        PrimitiveAttributeReplica<T> attribute = this.rawView.getAttributeRecord(attributeName);
        PrimitiveBoxReplica<T> pbox = attribute.getValue();
        assert (pbox.getValueClass().equals(SpecializedClass.fromPlain(this.primitiveClass)));
        assert (attribute.getAccess() == AttributeAccess.ATTRIBUTE_ACCESS_READ);
        return pbox.get();
    }

    @Override
    public void set(String attributeName, T value) {
        this.rawView.send(attributeName, value);
    }

    @Override
    public boolean exists(String attributeName, AttributeAccess access) {
        return this.rawView.exists(attributeName, access);
    }

    @Override
    public Iterator<ListMapEntryReplica<PrimitiveAttributeReplica<T>>> iterator() {
        return this.rawView.iterator();
    }
}

