/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.essence;

import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.emohawk.agent.module.essence.IEssenceMap;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ControllerInfoReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.essence.IEssenceReplication;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.HashMap;
import java.util.Map;

public class EssenceMap
implements IEssenceMap {
    protected IVisionWorldView worldView;
    protected HashMap<String, PawnReplication> pawns;
    protected HashMap<String, ControllerInfoReplication> controllers;
    protected ActionRegistryReplication actionRegistry;
    protected HashMap<String, IEssenceReplication> essences;

    public EssenceMap(IVisionWorldView worldView) {
        this.worldView = worldView;
        this.pawns = new HashMap();
        this.controllers = new HashMap();
        this.essences = new HashMap();
    }

    public void associatePawn(String botId, PawnReplication pawn) {
        this.pawns.put(botId, pawn);
    }

    @Override
    public PawnReplication retrievePawn(String botId) {
        return this.pawns.get(botId);
    }

    @Override
    public PawnReplication retrievePawn(IWorldObject worldObject) {
        if (worldObject instanceof Self) {
            return this.retrievePawn(((Self)worldObject).getBotId().getStringId());
        }
        return this.retrievePawn(worldObject.getId().getStringId());
    }

    public void associateController(String botId, ControllerInfoReplication controller) {
        this.controllers.put(botId, controller);
    }

    @Override
    public ControllerInfoReplication retrieveController(String botId) {
        return this.controllers.get(botId);
    }

    @Override
    public ControllerInfoReplication retrieveController(IWorldObject worldObject) {
        return this.retrieveController(worldObject.getId().getStringId());
    }

    public void associateActionRegistry(ActionRegistryReplication actionRegistry) {
        this.actionRegistry = actionRegistry;
    }

    @Override
    public ActionRegistryReplication retrieveActionRegistry() {
        return this.actionRegistry;
    }

    public void associateEssence(String worldObjectId, IEssenceReplication essence) {
        this.essences.put(worldObjectId, essence);
    }

    @Override
    public IEssenceReplication retrieveEssence(String worldObjectId) {
        return this.essences.get(worldObjectId);
    }

    @Override
    public IEssenceReplication retrieveEssence(IWorldObject entity) {
        return this.retrieveEssence(entity.getId().getStringId());
    }

    @Override
    public <Essence extends IEssenceReplication> Map<IWorldObject, Essence> getAllVisible(Class<Essence> essenceClass) {
        HashMap<IWorldObject, IEssenceReplication> retval = new HashMap<IWorldObject, IEssenceReplication>();
        for (Map.Entry entry : this.worldView.getVisible().entrySet()) {
            IWorldObject worldObject = this.worldView.get((WorldObjectId)entry.getKey());
            IEssenceReplication essence = this.retrieveEssence((IWorldObject)entry.getValue());
            if (essence == null) {
                essence = this.retrievePawn(worldObject);
            }
            if (essence == null || !essenceClass.isAssignableFrom(essence.getClass())) continue;
            IEssenceReplication castedEssence = essence;
            retval.put(worldObject, castedEssence);
        }
        return retval;
    }
}

