/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.emohawk.agent.module.replication;

import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.IReplicatedObjectTracker;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ControllerInfoReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.PawnReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.ActionRegistryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.AttributeManagerReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.IAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyref.FoggyRefAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.foggyreflist.FoggyRefListAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitive.PrimitiveAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.attribute.primitivelist.ListAttributeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.FoggyRefReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapEntryReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.ListMapReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.PrimitiveBoxReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListCoreReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListNodeReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.ds.sll.SinglyLinkedListReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IGenericObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.IObjectReplication;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.SpecializedClass;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamManager;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectReplication;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectTearOff;
import cz.cuni.amis.pogamut.emohawk.communication.replication.ObjectUpdate;
import cz.cuni.amis.pogamut.emohawk.communication.stream.PayloadType;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004Bot;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ObjectReplicationClient
implements IReplicatedObjectTracker {
    protected static String LETTER = "[a-zA-Z]";
    protected static String WORD = "(?:" + LETTER + "+)";
    protected static String RAW_PARAMETER = "(?:(?:" + LETTER + "|(?:__))+)";
    protected static Pattern GENERIC_CLASS_NAME_PATTERN = Pattern.compile(WORD + "(?:_" + RAW_PARAMETER + ")*");
    protected static Pattern GENERIC_CLASS_TYPE_PARAMETER_PATTERN = Pattern.compile(RAW_PARAMETER);
    protected HashMap<String, Class<?>> classMap;
    protected HashMap<Integer, IObjectReplication> objectMap;
    protected StreamManager streamManager;
    protected HashMap<Class<?>, Object> modules;
    protected IWorldEventListener<ObjectReplication> objectReplicationListener = new IWorldEventListener<ObjectReplication>(){

        public void notify(ObjectReplication event) {
            IObjectReplication object;
            ReplicationId replicationId = event.getReplicationId();
            String objectClass = event.getObjectClass();
            assert (!ObjectReplicationClient.this.exists(replicationId.getIndex()));
            SpecializedClass<?> specializedClass = ObjectReplicationClient.this.findClass(objectClass);
            assert (IObjectReplication.class.isAssignableFrom(specializedClass.getGenericClass()));
            try {
                object = (IObjectReplication)specializedClass.getGenericClass().newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            if (specializedClass.getGenericClass().getTypeParameters().length > 0) {
                IGenericObjectReplication genericObject = (IGenericObjectReplication)object;
                for (int i = 0; i < specializedClass.getGenericClass().getTypeParameters().length; ++i) {
                    genericObject.setTypeParameter(i, specializedClass.getTypeParameter(i));
                }
            }
            object.initializeImage(ObjectReplicationClient.this, replicationId);
            ObjectReplicationClient.this.objectMap.put(replicationId.getIndex(), object);
        }
    };
    protected IWorldEventListener<ObjectTearOff> objectTearOffListener = new IWorldEventListener<ObjectTearOff>(){

        public void notify(ObjectTearOff event) {
            int replicationIndex = event.getReplicationIndex();
            assert (ObjectReplicationClient.this.exists(replicationIndex));
            IObjectReplication object = ObjectReplicationClient.this.objectMap.get(replicationIndex);
            ObjectReplicationClient.this.objectMap.remove(replicationIndex);
            object.finalizeReplication();
        }
    };
    protected IWorldEventListener<ObjectUpdate> objectUpdateListener = new IWorldEventListener<ObjectUpdate>(){

        public void notify(ObjectUpdate event) {
            int replicationIndex = event.getReplicationIndex();
            IObjectReplication object = ObjectReplicationClient.this.getObject(replicationIndex);
            object.receive(ObjectReplicationClient.this.streamManager.getInputStream());
            assert (ObjectReplicationClient.this.streamManager.getInputStream().tellNext() == PayloadType.PAYLOAD_TYPE_EOF);
            ObjectReplicationClient.this.streamManager.clearInput();
        }
    };

    public ObjectReplicationClient(IUT2004Bot bot, StreamManager streamManager) {
        this.objectMap = new HashMap();
        this.classMap = new HashMap();
        this.streamManager = streamManager;
        this.modules = new HashMap();
        bot.getWorldView().addEventListener(ObjectReplication.class, this.objectReplicationListener);
        bot.getWorldView().addEventListener(ObjectUpdate.class, this.objectUpdateListener);
        bot.getWorldView().addEventListener(ObjectTearOff.class, this.objectTearOffListener);
        this.classMap.put("int", Integer.class);
        this.classMap.put("bool", Boolean.class);
        this.classMap.put("float", Float.class);
        this.classMap.put("string", String.class);
        this.classMap.put("EhIReplicableObject", IObjectReplication.class);
        this.classMap.put("EhPawn", PawnReplication.class);
        this.classMap.put("EhIAttribute", IAttributeReplication.class);
        this.classMap.put("EhSinglyLinkedList", SinglyLinkedListReplication.class);
        this.classMap.put("EhSinglyLinkedListCore", SinglyLinkedListCoreReplication.class);
        this.classMap.put("EhSinglyLinkedListNode", SinglyLinkedListNodeReplication.class);
        this.classMap.put("EhAttributeManager", AttributeManagerReplication.class);
        this.classMap.put("EhListMap", ListMapReplication.class);
        this.classMap.put("EhListMapEntry", ListMapEntryReplication.class);
        this.classMap.put("EhPrimitiveBox", PrimitiveBoxReplication.class);
        this.classMap.put("EhFoggyRef", FoggyRefReplication.class);
        this.classMap.put("EhPrimitiveAttribute", PrimitiveAttributeReplication.class);
        this.classMap.put("EhListAttribute", ListAttributeReplication.class);
        this.classMap.put("EhFoggyRefAttribute", FoggyRefAttributeReplication.class);
        this.classMap.put("EhFoggyRefListAttribute", FoggyRefListAttributeReplication.class);
        this.classMap.put("EhControllerInfo", ControllerInfoReplication.class);
        this.classMap.put("EhActionRegistry", ActionRegistryReplication.class);
    }

    @Override
    public IObjectReplication getObject(int replicationId) {
        assert (replicationId >= 0);
        assert (this.objectMap.containsKey(replicationId));
        return this.objectMap.get(replicationId);
    }

    @Override
    public boolean exists(int replicationId) {
        assert (replicationId >= 0);
        return this.objectMap.containsKey(replicationId);
    }

    public <T, M extends T> void registerModule(Class<T> moduleClass, M module) {
        assert (!this.modules.containsKey(moduleClass));
        this.modules.put(moduleClass, module);
    }

    public <T> T getModule(Class<T> moduleClass) {
        assert (this.modules.containsKey(moduleClass));
        Object retval = this.modules.get(moduleClass);
        return (T)retval;
    }

    protected SpecializedClass<?> findClass(String objectClass) {
        String className;
        if (!GENERIC_CLASS_NAME_PATTERN.matcher(objectClass).matches()) {
            throw new RuntimeException("Invalid class name \"" + objectClass + "\".");
        }
        LinkedList<String> typeParameters = new LinkedList<String>();
        if (objectClass.contains("_")) {
            className = objectClass.substring(0, objectClass.indexOf("_"));
            String parameterString = objectClass.substring(className.length() + 1);
            Matcher parameterMatcher = GENERIC_CLASS_TYPE_PARAMETER_PATTERN.matcher(parameterString);
            while (parameterMatcher.find()) {
                String parameter = parameterMatcher.group(0);
                typeParameters.add(parameter.replace("__", "_"));
            }
        } else {
            className = objectClass;
        }
        if (!this.classMap.containsKey(className)) {
            throw new RuntimeException("Can't replicate unknown class \"" + objectClass + "\".");
        }
        Class<?> genericClass = this.classMap.get(className);
        if (genericClass.getTypeParameters().length != typeParameters.size()) {
            throw new RuntimeException("Incorrect number of type parameters for \"" + className + "\" ( " + typeParameters + " ).");
        }
        LinkedList resolvedTypeParameters = new LinkedList();
        for (String typeParameter : typeParameters) {
            resolvedTypeParameters.add(this.findClass(typeParameter));
        }
        SpecializedClass retval = new SpecializedClass(genericClass, resolvedTypeParameters);
        return retval;
    }
}

