package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container;

import java.util.Collection;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.ObjectReplicationClient;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.object.ReplicationId;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.AbstractItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;

/** Abstract container item
 *  
 * Subclasses must override getDisplayName(), makeActor() and canStore().
 */
public abstract class AbstractContainerItemReplica extends AbstractItem implements IContainerReplica {

	protected PossessorComponent possessorComponent;
	
	@Override
	public boolean canStore( IItem item ) {
		return true;
	}
	
	@Override
	public boolean canRelease( IItem item )
	{
		return true;
	}
	
	@Override
	public Collection<? extends IItemReplica> readInventory()
	{
		return possessorComponent.readInventory();
	}
	
	@Override
	public void initializeImage( ObjectReplicationClient initObjectReplicationClient, ReplicationId initReplicationId )
	{
		super.initializeImage( initObjectReplicationClient, initReplicationId );
		possessorComponent =  new PossessorComponent( this, this );
	}
}