package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.container;

import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionReplica;
import cz.cuni.amis.pogamut.emohawk.agent.module.replication.image.action.IActionResultHandler;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.SerializationTools;
import cz.cuni.amis.pogamut.emohawk.agent.module.stream.StreamBuffer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.action.collector.ICollectorReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.IContainerReplica;

/** Store item in container action
 */
public class StoreItemInContainerActionReplica extends AbstractContainerActionReplica implements IActionReplica {

	public static final int ERROR_STORED_ITEM_NOT_IN_INVENTORY = 17;
	public static final int ERROR_CONTAINER_DENIED = 18;
	public static final int ERROR_COLLECTOR_DENIED = 19;
	
	/** Constructor
	 */
	public StoreItemInContainerActionReplica() {
	}
	
	@Override
	public String getActionName() {
		return "Store item in container";
	}
	
	/** Request action
	 *  
	 * @param performer action performer
	 * @param container container to store item to
	 * @param storedItem item to store, must be in performer's inventory
	 * @param resultHandler result handler
	 */
	public void request( ICollectorReplica performer, IContainerReplica container, IItemReplica storedItem, IActionResultHandler resultHandler )
	{
		StreamBuffer arguments = new StreamBuffer();
		SerializationTools.serializeObjectReferenceOnClient( arguments, container );
		SerializationTools.serializeObjectReferenceOnClient( arguments, storedItem );
		performer.requestAction(
			this,
			resultHandler,
			arguments
		);
	}
}
