package cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.container;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructor;
import cz.cuni.amis.pogamut.emohawk.agent.module.observationMemory.IDeferredConstructorChainer;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.ObservationMemory;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.IItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.observationMemory.memorization.item.AbstractItemMemorization;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItemReplica;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.IItem;
import cz.cuni.amis.pogamut.emohawkRpgBase.agent.module.replication.image.item.container.AbstractContainerItemReplica;

public class AbstractContainerItemMemorization
	<MemorizedClass extends AbstractContainerItemReplica>
	extends AbstractItemMemorization<MemorizedClass> 
	implements IContainerMemorization<MemorizedClass>, IItemMemorization<MemorizedClass> {
	
	protected List<IItemMemorization<IItemReplica>> inventory;
	
	public AbstractContainerItemMemorization( 
		final MemorizedClass object,
		final ObservationMemory observationMemory,
		IDeferredConstructorChainer deferredConstructorChainer 
	) {
		super( object, observationMemory, deferredConstructorChainer );
		
		deferredConstructorChainer.addDeferredConstructor(
			new IDeferredConstructor() {
				@Override
				public void construct() {
					inventory = new LinkedList<IItemMemorization<IItemReplica>>();
					for ( IItemReplica item : object.readInventory() ) {
						inventory.add( (IItemMemorization<IItemReplica>) observationMemory.getMemorization( item ) );
					}
				}
			}
		);
	}

	@Override
	public boolean canStore(IItem item) {
		return true;
	}

	@Override
	public boolean canRelease(IItem item) {
		return true;
	}

	@Override
	public Collection<? extends IItemMemorization<? extends IItemReplica>> readInventory() {
		return Collections.unmodifiableList( inventory );
	}
}