package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for AirBase building.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum AirBaseState implements IState {
	
	FIGHTER_LAUNCH(JBot.STATE_AIRBASEFIGHTERLAUNCH),
    BOMBER_LAUNCH(JBot.STATE_AIRBASEBOMBERLAUNCH);
	
	private static Map<Integer, AirBaseState> states = new HashMap<Integer, AirBaseState>();
	
	public static AirBaseState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (AirBaseState state : AirBaseState.values()) {
			states.put(state.getStateId(), state);
		}
	}

	private AirBaseState(int id) {
		this.id = id;		
	}

	public final int id;

	@Override
	public int getStateId() {
		return id;
	}

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
