package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridCell;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGridCellId;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;

/**
 * A single square cell for the experimental grid.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class SymmetricGridCell implements IGridCell {

	// protected LinkedList<IGridCellFlag> complexFlags = new
	// LinkedList<IGridCellFlag>();

	// protected static BasicGrid grid;

	protected SymmetricGridCellId cellId;

	/*
	 * public static void setGrid(BasicGrid grid) { SymmetricGridCell.grid =
	 * grid; }
	 */

	protected static GameInfo gameInfo;

	public static void setGameInfo(GameInfo gameInfo) {
		SymmetricGridCell.gameInfo = gameInfo;
	}

	public SymmetricGridCell(SymmetricGridCellId cellId) {
		this.cellId = cellId;
	}

	public SymmetricGridCell(float x, float y) {
		cellId = new SymmetricGridCellId(x, y);
	}

	/*
	 * @Override public void setFlag(IGridCellFlag flag) {
	 * complexFlags.add(flag); }
	 * 
	 * @Override public boolean hasFlag(Class<? extends IGridCellFlag> flag) {
	 * return getFlag(flag) != null; }
	 * 
	 * @Override public boolean hasFlag(IGridCellFlag flag) { return
	 * complexFlags.contains(flag); }
	 */
	@Override
	public boolean hasFlag(BasicFlag flag) {
		return hasFlag(cellId.getX(), cellId.getY(), flag);
	}

	public static boolean hasFlag(Location location, BasicFlag flag) {
		return location != null
				&& hasFlag(
						(float) location.getX(),
						(float) location.getY(),
						flag);
	}

	public static boolean hasFlag(float x, float y, BasicFlag flag) {

		if (x < -180f || x > 180f || y < -90f || y > 90f)
			return false;

		switch (flag) {
			case SEA:
				return gameInfo.isValidTerritory(-1, x, y, true);
			case LAND:
				return gameInfo.isValidTerritory(-1, x, y, false);
			case OWN_TERRITORY: {
				int id = gameInfo.getOwnTeamId();
				return gameInfo.isValidTerritory(id, x, y, false)
						|| gameInfo.isValidTerritory(id, x, y, true);
			}
			case ENEMY_TERRITORY: {
				Boolean ok = false;
				for (int id : gameInfo.getEnemyTeamIds()) {
					if (ok = gameInfo.isValidTerritory(id, x, y, false) ||
							gameInfo.isValidTerritory(id, x, y, true))
						break;
				}
				return ok;
			}
			case OWN_PLACEABLE_LAND: {
				return gameInfo.isValidPlacementLocation(x, y, UnitType.RADAR);
			}
			case OWN_PLACEABLE_SEA:
				return gameInfo.isValidPlacementLocation(
						x, y, UnitType.BATTLE_SHIP);
		}
		return false;
	}

	/*
	 * @SuppressWarnings("unchecked")
	 * 
	 * @Override public <T extends IGridCellFlag> T getFlag(Class<? extends T>
	 * flag) { for (IGridCellFlag set_flag : complexFlags) { if (flag ==
	 * set_flag.getClass()) return (T) set_flag; } return null; }
	 *//*
		 * @Override public boolean removeFlag(IGridCellFlag flag) { return
		 * complexFlags.remove(flag); }
		 */
	@Override
	public IGridCellId getCellId() {
		return cellId;
	}
	/*
	 * public CellIndices getCellIndices() { return
	 * grid.getCellIndices((SymmetricGridCellId) getCellId()); }
	 */
}
