/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.quadtree;

import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreePostorderIterator;
import java.util.NoSuchElementException;

public class DepthLimitedQuadTreePostorderIterator
extends QuadTreePostorderIterator {
    private int maxDepth;

    public DepthLimitedQuadTreePostorderIterator(QuadTree tree, int maxDepth) {
        super(tree);
        if (maxDepth <= 0) {
            throw new IllegalArgumentException("maxDepth argument " + maxDepth + " cannot be <= 0.");
        }
        this.maxDepth = maxDepth;
    }

    @Override
    public QuadTreeNode next() {
        if (this.getNode() == null) {
            if (this.isFinished() || this.getRoot() == null) {
                throw new NoSuchElementException("No more elements in iterated QuadTree");
            }
            this.setNode(this.getRoot());
            while (this.getNode().getNodes() != null && this.getBranching().size() < this.maxDepth) {
                this.setNode(this.getNode().getFirst());
                this.getBranching().add(0);
            }
            if (this.getNode() == this.getRoot()) {
                this.setFinished(true);
            }
            return this.getNode();
        }
        this.setNode(this.getNode().getParent());
        int next = this.getBranching().pollLast();
        if (next == 3) {
            if (this.getNode() == this.getRoot()) {
                this.setFinished(true);
            }
            return this.getNode();
        }
        this.getBranching().add(++next);
        this.setNode(this.getNode().getNodes()[next]);
        while (this.getNode().getNodes() != null && this.getBranching().size() < this.maxDepth) {
            this.setNode(this.getNode().getFirst());
            this.getBranching().add(0);
        }
        return this.getNode();
    }
}

