/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic;

import cz.cuni.amis.pogamut.base.agent.IObservingAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.defcon.agent.DefConAgent;
import cz.cuni.amis.pogamut.defcon.communication.worldview.DefConWorldView;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.IGrid;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.BasicGridIterator;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.SymmetricGridCell;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.basic.SymmetricGridCellId;
import java.util.logging.Logger;

public class BasicGrid<AGENT extends DefConAgent>
extends SensorModule<AGENT>
implements IGrid<SymmetricGridCell, SymmetricGridCellId, BasicGridIterator> {
    protected float gridXStart;
    protected float gridYStart;
    protected float gridStep;
    protected int gridXCellCount;
    protected int gridYCellCount;

    public BasicGrid(AGENT agent, float gridStep, int gridXCellCount, int gridYCellCount, int gridXStart, int gridYStart) {
        this((DefConAgent)agent, gridStep, gridXCellCount, gridYCellCount, gridXStart, gridYStart, null);
    }

    public BasicGrid(DefConAgent agent, float gridStep, int gridXCellCount, int gridYCellCount, int gridXStart, int gridYStart, Logger log) {
        super((IObservingAgent)agent, log);
        this.initGrid(gridStep, gridXCellCount, gridYCellCount, gridXStart, gridYStart);
    }

    protected void initGrid(float gridStep, int gridXCellCount, int gridYCellCount, float gridXStart, float gridYStart) {
        this.gridStep = gridStep;
        this.gridXCellCount = gridXCellCount;
        this.gridYCellCount = gridYCellCount;
        this.gridXStart = gridXStart;
        this.gridYStart = gridYStart;
    }

    @Override
    public SymmetricGridCell getCell(SymmetricGridCellId cellId) {
        return new SymmetricGridCell(cellId);
    }

    public CellIndices getCellIndices(SymmetricGridCellId cellId) {
        return new CellIndices((int)(Math.floor((cellId.getX() - this.gridXStart) / this.gridStep) + (double)this.gridXStart), (int)(Math.floor(cellId.getY() - this.gridYStart) / (double)this.gridStep + (double)this.gridYStart));
    }

    @Override
    public DefConWorldView getWorldView() {
        return (DefConWorldView)this.worldView;
    }

    public float getLowerXBound() {
        return this.gridXStart;
    }

    public float getUpperXBound() {
        return (float)this.gridXCellCount * this.gridStep - this.gridXStart;
    }

    public float getLowerYBound() {
        return this.gridYStart;
    }

    public float getUpperYBound() {
        return (float)this.gridYCellCount * this.gridStep - this.gridYStart;
    }

    public float getGridStep() {
        return this.gridStep;
    }

    public int getXCount() {
        return this.gridXCellCount;
    }

    public int getYCount() {
        return this.gridYCellCount;
    }

    public SymmetricGridCell getCell(float x, float y) {
        if (y < this.gridYStart || y >= (float)this.gridYCellCount - this.gridYStart) {
            return null;
        }
        return new SymmetricGridCell(new SymmetricGridCellId((x - this.gridXStart) / this.gridStep % (float)this.gridXCellCount + this.gridXStart, y));
    }

    @Override
    public BasicGridIterator getIterator(SymmetricGridCellId cellId) {
        return new BasicGridIterator(cellId, this);
    }

    public class CellIndices {
        private float x;
        private float y;

        public CellIndices(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public CellIndices(CellIndices source) {
            this.x = source.getX();
            this.y = source.getY();
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public float setX(int x) {
            this.x = x;
            return this.x;
        }

        public float setY(int y) {
            this.y = y;
            return this.y;
        }

        public CellIndices setIndices(SymmetricGridCellId cellId, BasicGrid grid) {
            this.x = (float)(Math.floor((cellId.getX() - BasicGrid.this.gridXStart) / BasicGrid.this.gridStep) * (double)BasicGrid.this.gridStep) + BasicGrid.this.gridXStart;
            this.y = (float)(Math.floor((cellId.getY() - BasicGrid.this.gridYStart) / BasicGrid.this.gridStep) * (double)BasicGrid.this.gridStep) + BasicGrid.this.gridYStart;
            return this;
        }

        public boolean equals(Object o) {
            return o instanceof CellIndices && ((CellIndices)o).getX() == this.x && ((CellIndices)o).getY() == this.y;
        }
    }
}

