/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.base3d.worldview.object;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;

public class DefConLocation
extends Location {
    public DefConLocation() {
        super(0.0, 0.0, 0.0);
    }

    public DefConLocation(double x, double y) {
        super(DefConLocation.correctX(x, y), y);
        if (y > 100.0 || y < -100.0) {
            throw new IllegalArgumentException("DefConLocation Y coord must be inside <-100, 100>");
        }
    }

    public DefConLocation(float[] f) {
        this(f[0], f[1]);
    }

    public DefConLocation(double[] d) {
        this(d[0], d[1]);
    }

    public DefConLocation(Location location) {
        this(location.getX(), location.getY());
    }

    public double getDistance2D(Location location) {
        return this.getDistance(location);
    }

    public double getDistance(Location location) {
        double x = 0.0;
        double y = 0.0;
        double diff = this.x - location.x;
        x = diff > 180.0 ? this.x - 360.0 - location.x : (diff < -180.0 ? this.x + 360.0 - location.x : this.x - location.x);
        y = this.y - location.y;
        return new Location(x, y).getLength();
    }

    public static Location sub(DefConLocation l1, DefConLocation l2) {
        double x = 0.0;
        double y = 0.0;
        double diff = l1.x - l2.x;
        x = diff > 180.0 ? l1.x - 360.0 - l2.x : (diff < -180.0 ? l1.x + 360.0 - l2.x : l1.x - l2.x);
        y = l1.y - l2.y;
        return new Location(x, y);
    }

    protected static double correctX(double x, double y) {
        if (y > 100.0 || y < -100.0) {
            throw new IllegalArgumentException("DefConLocation Y coord must be inside <-100, 100>. " + y);
        }
        return DefConLocation.mathModulus(x + 180.0, 360.0) - 180.0;
    }

    protected static final double mathModulus(double a, double b) {
        return (a % b + b) % b;
    }

    public DefConLocation scale(double d) {
        return new DefConLocation(super.scale(d));
    }

    public DefConLocation add(Location l) {
        double x = 0.0;
        double y = 0.0;
        double diff = x - l.x;
        x = diff > 180.0 ? x + 360.0 + l.x : (diff < -180.0 ? x - 360.0 + l.x : (x += l.x));
        return new DefConLocation(x, y += l.y);
    }

    public Location sub(DefConLocation l) {
        return DefConLocation.sub(this, l);
    }

    public DefConLocation getNormalized() {
        return new DefConLocation(super.getNormalized());
    }

    public DefConLocation invert() {
        return new DefConLocation(-this.x, -this.y);
    }

    public double getDistanceSquare(Location l) {
        l = this.sub(l);
        double dx = l.x;
        double dy = l.y;
        double dz = l.z;
        return dx * dx + dy * dy + dz * dz;
    }
}

