package cz.cuni.amis.pogamut.defcon.communication.worldview.modules.managers.buildings;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import cz.cuni.amis.pogamut.defcon.agent.impl.DefConAgentLogicController;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConUnitObject;
import cz.cuni.amis.pogamut.defcon.communication.worldview.polygons.GameMapInfoPolygons;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;
import cz.cuni.amis.pogamut.defcon.utils.Pair;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeBFSIterator;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreesManager;

/**
 * Looks up good places for placing buildings.
 * 
 * @author Radek 'Black_Hand' Pibil
 * 
 */
public class BuildingPlacementProvider {

	private DefConAgentLogicController<?> logic;
	private GameMapInfoPolygons mapInfo;
	private QuadTreesManager qTreesManager;

	public BuildingPlacementProvider(DefConAgentLogicController<?> logic,
			GameMapInfoPolygons mapInfo, QuadTreesManager qTreesManager) {
		this.logic = logic;
		this.mapInfo = mapInfo;
		this.qTreesManager = qTreesManager;
	}

	/**
	 * Returns a list of locations for building places, trying and putting them
	 * at least minDistance far.
	 * 
	 * @param minDistance
	 * @param count
	 * @param buildingType
	 * @return
	 */
	public List<DefConLocation> getLocations(double minDistance, int count,
			UnitType buildingType) {
		ArrayList<DefConLocation> locations = new ArrayList<DefConLocation>();

		while (count > locations.size() && minDistance >= 5d) {
			collectLocationsForBuildings(
					locations,
					minDistance,
					count,
					buildingType);
			minDistance -= 5d;
		}

		return locations;
	}

	private void collectLocationsForBuildings(
			ArrayList<DefConLocation> locations,
			double minDistance, int count, UnitType buildingType) {
		

		for (Pair<List<QuadTree>, List<QuadTree>> territory : qTreesManager
				.getOwnQuadTrees().values()) {

			for (QuadTree qTree : territory.second) {

				Iterator<QuadTreeNode> nodeIterator = new QuadTreeBFSIterator(
						qTree);
				while (nodeIterator.hasNext()) {

					QuadTreeNode node = nodeIterator.next();

					if (node.getNodes() != null || !node.isLabeled())
						continue;

					// logic.getLog().info("blabal");


					// if locations are empty it doesnt yet mean that its ok to
					// place it here
					boolean far_enough_from_others = true;

					final Class<? extends DefConUnitObject<?>> buildingClass = (Class<? extends DefConUnitObject<?>>) buildingType
							.getClassOfUnitType();

					for (DefConUnitObject<?> other_buildings : logic
							.getWorldView()
							.getAll(buildingClass).values()) {

						if (other_buildings.getTeamId() != logic.getGameInfo()
								.getOwnTeamId())
							continue;

						if (!logic.getGameInfo()
								.isValidBuildingPlacementLocation(
										node.getCenter())
								|| other_buildings.getLocation().getDistance2D(
										node.getCenter()) < minDistance) {
							far_enough_from_others = false;

							// logic.getLog().info(
							// "othersdist: "
							// + other_buildings.getLocation()
							// + " " + node.getCenter() + " "
							// + other_buildings.getLocation()
							// .getDistance2D(node
							// .getCenter()) + " "
							// + minDistance);
							//
							// logic.getAct().act(
							// new WhiteboardDraw(new DefConLocation(node
							// .getCenter()), new DefConLocation(
							// node
							// .getCenter())
							// .add(new Location(0.5d,
							// 0.5d))));
							break;
						}

					}

					if (far_enough_from_others) {
						for (DefConLocation other : locations) {

							if (!logic.getGameInfo()
									.isValidBuildingPlacementLocation(
											node.getCenter())
									|| other.getDistance2D(node.getCenter()) < minDistance) {
								far_enough_from_others = false;

								// logic.getLog().info(
								// "othersdist2: " + other.getLocation()
								// + " "
								// + node.getCenter()
								// + " "
								// + other.getDistance2D(node
								// .getCenter()) + " "
								// + minDistance);
								//
								// logic.getAct().act(
								// new WhiteboardDraw(new DefConLocation(
								// node
								// .getCenter()),
								// new DefConLocation(node
								// .getCenter())
								// .add(new Location(0.5d,
								// 0.5d))));
								break;
							}
						}
					}

					if (!far_enough_from_others)
						continue;

					locations.add(new DefConLocation(node.getCenter()));

					if (locations.size() >= count)
						return;
				}
			}
		}
	}
}
