/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.utils.tests.qtree;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTree;
import cz.cuni.amis.pogamut.defcon.utils.quadtree.QuadTreeNode;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;
import javax.swing.JScrollPane;

public class QuadTreeVisualizer
extends JScrollPane {
    private QuadTree qTree;
    private List<Location> poly;
    private static final double FACTOR = 5.0;

    public QuadTreeVisualizer(QuadTree qTree, List<Location> poly) {
        super(22, 32);
        this.qTree = qTree;
        this.poly = poly;
        this.setSize(1024, 768);
        this.setVisible(true);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Color old_color = g2d.getBackground();
        g2d.setBackground(Color.WHITE);
        g2d.clearRect(0, 0, this.getWidth(), this.getHeight());
        g2d.setBackground(old_color);
        old_color = g2d.getColor();
        g2d.setColor(Color.GRAY);
        double offset_x = this.qTree.getRoot().getX1();
        double offset_y = this.qTree.getRoot().getY1();
        double max_x = this.qTree.getRoot().getX2();
        double max_y = this.qTree.getRoot().getY2();
        g2d.setColor(Color.RED);
        for (QuadTreeNode node : this.qTree) {
            int width = (int)((node.getX2() - node.getX1()) * 5.0) - 4;
            int height = (int)((node.getY2() - node.getY1()) * 5.0) - 4;
            int x = (int)((node.getX1() - offset_x) * 5.0) + 2;
            int y = (int)((node.getY1() - offset_y) * 5.0) + 2;
            if (node.isLabeled()) {
                g2d.setColor(Color.GREEN);
            }
            g2d.drawRect(x, y, width, height);
            g2d.setColor(Color.RED);
        }
        g2d.setColor(Color.BLUE);
        Location last = this.poly.get(this.poly.size() - 1);
        for (Location node : this.poly) {
            int x1 = (int)((last.getX() - offset_x) * 5.0);
            int y1 = (int)((last.getY() - offset_y) * 5.0);
            int x2 = (int)((node.getX() - offset_x) * 5.0);
            int y2 = (int)((node.getY() - offset_y) * 5.0);
            g2d.drawLine(x1, y1, x2, y2);
            last = node;
        }
        g2d.setColor(Color.BLACK);
        g2d.drawRect(0, 0, 5, 5);
        g2d.drawRect((int)((max_x - offset_x) * 5.0 - 5.0), 0, 5, 5);
        g2d.drawRect(0, (int)((max_y - offset_y) * 5.0 - 5.0), 5, 5);
        g2d.drawRect((int)((max_x - offset_x) * 5.0 - 5.0), (int)((max_y - offset_y) * 5.0 - 5.0), 5, 5);
        g2d.setColor(old_color);
    }
}

