/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.generator;

import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.consts.UnitType;

public class FleetGenerator {
    public static UnitType[] getNewFleet(FleetType type, GameInfo info) {
        UnitType[] output = null;
        switch (type) {
            case SUBS: {
                output = FleetGenerator.fillWith(UnitType.SUB, info);
                break;
            }
            case CARRIERS: {
                output = FleetGenerator.fillWith(UnitType.CARRIER, info);
                break;
            }
            case BATTLESHIPS: {
                output = FleetGenerator.fillWith(UnitType.BATTLE_SHIP, info);
                break;
            }
            case CARRIERS_WITH_SUBS: {
                output = new UnitType[]{UnitType.CARRIER, UnitType.CARRIER, UnitType.CARRIER, UnitType.SUB, UnitType.SUB, UnitType.SUB};
                break;
            }
            case CARRIERS_WITH_BATTLESHIPS: {
                output = new UnitType[]{UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.CARRIER, UnitType.CARRIER, UnitType.CARRIER};
                break;
            }
            case BATTLESHIPS_WITH_SUBS: {
                output = new UnitType[]{UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.SUB, UnitType.SUB, UnitType.SUB};
                break;
            }
            case MIXED: {
                output = new UnitType[]{UnitType.BATTLE_SHIP, UnitType.BATTLE_SHIP, UnitType.CARRIER, UnitType.CARRIER, UnitType.SUB, UnitType.SUB};
            }
        }
        return output;
    }

    private static UnitType[] fillWith(UnitType type, GameInfo info) {
        int i;
        int price_for_one;
        int creds_left = info.getUnitCredits();
        if (creds_left < (price_for_one = info.getUnitValue(type))) {
            return null;
        }
        UnitType[] output = new UnitType[6];
        for (i = 0; i < 6 && creds_left >= price_for_one; creds_left -= price_for_one, ++i) {
            output[i] = type;
        }
        while (i < 6) {
            output[i] = null;
            ++i;
        }
        return output;
    }

    public static enum FleetType {
        SUBS,
        CARRIERS,
        BATTLESHIPS,
        CARRIERS_WITH_SUBS,
        CARRIERS_WITH_BATTLESHIPS,
        BATTLESHIPS_WITH_SUBS,
        MIXED;

    }
}

