package cz.cuni.amis.pogamut.defcon.consts.state;

import java.util.HashMap;
import java.util.Map;

import javabot.JBot;

/**
 * Contains all states for Submarines.
 * 
 * @author Radek 'Black_Hand' Pibil
 *
 */
public enum SubState implements IState {
	
	PASSIVE_SONAR(JBot.STATE_SUBPASSIVESONAR), 
    ACTIVE_SONAR(JBot.STATE_SUBACTIVESONAR),  
    NUKE(JBot.STATE_SUBNUKE);
	
	private static Map<Integer, SubState> states = new HashMap<Integer, SubState>();
	
	public static SubState getState(int stateId) {
		return states.get(stateId);
	}
	
	static {
		for (SubState state : SubState.values()) {
			states.put(state.getStateId(), state);
		}
	}	

	public final int id;
	
	private SubState(int id) {
		this.id = id;
	}

	@Override
	public int getStateId() {
		return id;
	}	

	@Override
	public Enum<? extends IState> getEnum() {
		return this;
	}

}
