package javabot;

import java.util.Collection;

import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.defcon.communication.messages.commands.DefConCommand;
import cz.cuni.amis.utils.ClassUtils;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.Listeners;
import cz.cuni.amis.utils.listener.ListenersMap;

/**
 * Executes a command and reports to all listeners to that command.
 * SendCommand is called by PogamutJBotSupport periodically when batches are being sent.
 * @author Radek 'Black_Hand' Pibil
 *
 */
public class ActExecutor {
	

	private ListenersMap<Class> listeners = new ListenersMap<Class>();
	
	private LogCategory log;
	
	private IComponentBus eventBus;
	
	private static class CommandMessageListenerNotifier implements Listeners.ListenerNotifier<IListener> {
		
		private CommandMessage msg;
		
		public void setMessage(CommandMessage msg) {
			this.msg = msg;
		}

		@Override
		public void notify(IListener listener) {
			listener.notify(msg);
		}

		@Override
		public Object getEvent() {
			return msg;
		}
	}
	
	private CommandMessageListenerNotifier notifier = new CommandMessageListenerNotifier();	
		
	public void act(CommandMessage command)
			throws ComponentNotRunningException, ComponentPausedException {

		if (command instanceof DefConCommand)
			PogamutJBotSupport.addCommand((DefConCommand)command);
	}

	public void addCommandListener(Class commandClass, ICommandListener listener) {
		listeners.add(commandClass, listener);
	}

	public boolean isCommandListening(Class commandClass,
			ICommandListener listener) {
		return listeners.isListening(commandClass, listener);		
	}

	public void removeCommandListener(Class commandClass,
			ICommandListener listener) {
		listeners.remove(commandClass, listener);
	}
	
	public void sendCommand(DefConCommand command) {
		// PogamutJBotSupport.writeToConsole("Sending: " + command);
		notifier.setMessage(command);
		Collection<Class> commandClasses = ClassUtils.getSubclasses(command.getClass());
		for (Class cls : commandClasses) {
			listeners.notify(cls, notifier);
		}
		if (!(command instanceof DefConCommand))
			return;
		
		command.perform();	
	}
}
