/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base3d.worldview.impl.LockableBatchAwareWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.defcon.agent.module.sensor.GameInfo;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.DefConViewableObject;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.EventBatchBegin;
import cz.cuni.amis.pogamut.defcon.communication.messages.infos.EventBatchEnd;
import cz.cuni.amis.pogamut.defcon.communication.translator.DefConMessageProducer;
import cz.cuni.amis.utils.exception.PogamutException;
import java.lang.reflect.Field;

@AgentScoped
public class DefConWorldView
extends LockableBatchAwareWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "DefConWorldViewDependency";
    private Field visibleField = null;
    private DefConMessageProducer messageProducer;
    private static final double maxX = 180.0;
    private static final double minX = -180.0;
    private static final double maxY = 100.0;
    private static final double minY = -100.0;

    @Inject
    public DefConWorldView(@Named(value="DefConWorldViewDependency") ComponentDependencies dependencies, DefConMessageProducer messageProducer, IComponentBus bus, IAgentLogger log) {
        super(dependencies, bus, log);
        this.messageProducer = messageProducer;
    }

    protected boolean isBatchBeginEvent(IWorldChangeEvent evt) {
        return evt instanceof EventBatchBegin;
    }

    protected boolean isBatchEndEvent(IWorldChangeEvent evt) {
        return evt instanceof EventBatchEnd;
    }

    protected void setDisappearedFlag(IViewable obj) {
        if (obj instanceof DefConViewableObject) {
            try {
                this.getField((DefConViewableObject)obj).set(obj, false);
            }
            catch (Exception e) {
                throw new PogamutException("Can't set 'visible' field: " + e.getMessage(), (Throwable)e, (Object)this);
            }
        }
    }

    private Field getField(DefConViewableObject obj) {
        if (this.visibleField == null) {
            try {
                this.visibleField = DefConViewableObject.class.getDeclaredField("visible");
                this.visibleField.setAccessible(true);
            }
            catch (Exception e) {
                throw new PogamutException("DefConViewableObject " + obj + " doesn't contain 'visible' field???", (Throwable)e, (Object)this);
            }
        }
        return this.visibleField;
    }

    public void update() {
        if (this.eventBus.isRunning()) {
            IWorldChangeEvent event;
            this.lock();
            while ((event = this.messageProducer.getEvent()) != null) {
                this.notify(event);
            }
            this.unlock();
        }
    }

    public float getStartTime() {
        return this.messageProducer.getStartTime();
    }

    public float getCurrentTime() {
        return this.messageProducer.getCurrentTime();
    }

    public GameInfo getGameInfo() {
        return this.messageProducer.getGameInfo();
    }

    public double getMinX() {
        return -180.0;
    }

    public double getMaxX() {
        return 180.0;
    }

    public double getMinY() {
        return -100.0;
    }

    public double getMaxY() {
        return 100.0;
    }

    public double getXSize() {
        return 360.0;
    }

    public double getYSize() {
        return 200.0;
    }

    public void updateProducer() {
        this.messageProducer.update();
    }
}

