/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.defcon.communication.worldview;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.defcon.base3d.worldview.object.DefConLocation;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.BasicFlag;
import cz.cuni.amis.pogamut.defcon.communication.worldview.modules.grid.flags.IFlagChecker;
import javabot.PogamutJBotSupport;

public abstract class AbstractMapSource
implements IFlagChecker {
    public static final double STEP = 1.0;

    @Override
    public DefConLocation traceFromTo(DefConLocation start, DefConLocation end, BasicFlag flag) {
        Location direction = end.sub(start);
        Location step = direction.getNormalized().scale(1.0);
        DefConLocation working = new DefConLocation(end);
        while (direction.dot(working.sub(start)) > 0.0) {
            if (this.hasFlag(working, flag)) {
                return working;
            }
            working.setTo(working.getX() - step.getX(), working.getY() - step.getY(), 0.0);
        }
        return this.hasFlag(start, flag) ? start : null;
    }

    @Override
    public DefConLocation traceFromTo(DefConLocation start, DefConLocation end, BasicFlag flag, double distance) {
        Location direction = end.sub(start);
        Location step = direction.getNormalized().scale(1.0);
        DefConLocation working = new DefConLocation(end);
        DefConLocation lastLocation = new DefConLocation();
        DefConLocation okLocation = null;
        distance *= distance;
        while (direction.dot(working.sub(start)) > 0.0) {
            double dist;
            if (this.hasFlag(working, flag)) {
                lastLocation.setTo(working);
                if (okLocation == null) {
                    okLocation = new DefConLocation(lastLocation);
                }
            } else {
                okLocation = null;
            }
            if (okLocation != null && (dist = okLocation.getDistanceSquare(working)) > distance) {
                return new DefConLocation(lastLocation);
            }
            working.setTo(working.getX() - step.getX(), working.getY() - step.getY());
        }
        if (okLocation != null) {
            return okLocation;
        }
        if (!this.hasFlag(start, flag)) {
            PogamutJBotSupport.writeToConsole("TraceFromTo: Flag start invalid " + (Object)((Object)start));
        }
        return this.hasFlag(start, flag) ? start : null;
    }
}

