/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.controller;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.ISharedComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.controller.AbstractComponentControllerBase;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.controller.IComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.IComponentController;
import cz.cuni.amis.pogamut.base.component.controller.ISharedComponentControlHelper;
import cz.cuni.amis.pogamut.base.component.controller.ISharedComponentController;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantPauseException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantResumeException;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.token.IToken;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SharedComponentController<COMPONENT extends ISharedComponent>
extends AbstractComponentControllerBase<COMPONENT>
implements ISharedComponentController<COMPONENT> {
    protected Object ctrlMutex = new Object();
    protected Map<IAgentId, ControlHelper> localControlHelpers = new HashMap<IAgentId, ControlHelper>();
    protected Map<IAgentId, LocalController> localControllers = new HashMap<IAgentId, LocalController>();
    protected Map<IAgentId, ComponentState> componentStates = new HashMap<IAgentId, ComponentState>();
    protected Map<ComponentState, Integer> componentStateCount = new HashMap<ComponentState, Integer>();
    protected IFatalErrorEvent fatalError;
    boolean killing = false;

    public SharedComponentController(COMPONENT component, ISharedComponentControlHelper componentControl, Logger log) {
        super(component, componentControl, log);
        ComponentState[] componentStateArray = ComponentState.values();
        int n = componentStateArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentState state = componentStateArray[n2];
            this.componentStateCount.put(state, 0);
            ++n2;
        }
    }

    @Override
    public ISharedComponentControlHelper getComponentControl() {
        return (ISharedComponentControlHelper)super.getComponentControl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addComponentBus(IAgentId agentId, ILifecycleBus bus, ComponentDependencies dependencies) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.isUsedBy(agentId)) {
                throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] is already a member of the " + agentId.getToken() + " lifecycle bus!", (Object)this);
            }
            ControlHelper helper = new ControlHelper(agentId);
            this.localControlHelpers.put(agentId, helper);
            IComponentController<ISharedComponent> controller = bus.addLifecycleManagement((ISharedComponent)this.component, helper, dependencies);
            LocalController localController = new LocalController(agentId, controller);
            this.localControllers.put(agentId, localController);
            this.setState(agentId, (ComponentState)((Object)controller.getState().getFlag()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeComponentBus(IAgentId agentId, ILifecycleBus bus) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (!this.isUsedBy(agentId)) {
                if (this.log.isLoggable(Level.WARNING)) {
                    this.log.warning(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] is not registered for agent " + agentId.getToken() + ", can't perform removeComponentBus().");
                }
                return;
            }
            bus.removeLifecycleManagement(this.component);
            this.localControllers.remove(agentId);
            bus.remove(this.component);
            bus.remove(this);
            this.setState(agentId, null);
        }
    }

    @Override
    public boolean isUsedBy(IAgentId agentId) {
        return this.localControllers.containsKey(agentId);
    }

    @Override
    public boolean isDependent(IAgentId agentId, IToken componentId) {
        LocalController helper = this.localControllers.get(agentId);
        if (helper == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] is not registered for agent " + agentId.getToken() + ", can't perform isDependent(" + componentId.getToken() + ").");
            }
            return false;
        }
        return helper.controller.isDependent(componentId);
    }

    @Override
    public boolean isDependent(IAgentId agentId, IComponent component) {
        LocalController helper = this.localControllers.get(agentId);
        if (helper == null) {
            if (this.log.isLoggable(Level.WARNING)) {
                this.log.warning(String.valueOf(this.id(component)) + "[" + this.getState().getFlag() + "] is not registered for agent " + agentId.getToken() + ", can't perform isDependent(" + this.id(component) + ").");
            }
            return false;
        }
        return helper.controller.isDependent(component);
    }

    @Override
    public void fatalError(String message) {
        this.kill(null, message, null);
    }

    @Override
    public void fatalError(String message, Throwable e) {
        this.kill(null, message, e);
    }

    @Override
    public IFatalErrorEvent getFatalError() {
        return this.fatalError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStart(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + " in state " + this.getState().getFlag() + ", can't manual start (" + reason + ")!", this);
            }
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStartPaused(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.INSTANTIATED, ComponentState.RESETED, ComponentState.STOPPED)) {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "], can't manual start paused (reason: " + reason + ")!", this);
            }
            this.startPaused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualPause(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.RUNNING)) {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "], can't manual pause (reason: " + reason + ")!", this);
            }
            this.startPaused();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualResume(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.PAUSED)) {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "], can't manual reason (reason: " + reason + ")!", this);
            }
            this.resume();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualStop(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.notInState(ComponentState.PAUSED, ComponentState.RUNNING)) {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "], can't manual reason (reason: " + reason + ")!", this);
            }
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manualKill(String reason) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.inState(ComponentState.KILLING, ComponentState.KILLED)) {
                return;
            }
            this.kill(null, reason, null);
        }
    }

    public int getStateCount(ComponentState ... states) {
        if (states == null) {
            return 0;
        }
        if (states.length == 0) {
            return 0;
        }
        if (states.length == 1) {
            return this.componentStateCount.get((Object)states[0]);
        }
        int count = 0;
        ComponentState[] componentStateArray = states;
        int n = states.length;
        int n2 = 0;
        while (n2 < n) {
            ComponentState state = componentStateArray[n2];
            count += this.componentStateCount.get((Object)state).intValue();
            ++n2;
        }
        return count;
    }

    protected void checkStateCount(int newCount, ComponentState state) {
        if (newCount < 0) {
            throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] attempt to change state count of " + (Object)((Object)state) + " to " + newCount + ", invalid.", (Object)this);
        }
        if (newCount > this.componentStates.size()) {
            throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] attempt to change state count of " + (Object)((Object)state) + " to " + newCount + " > " + this.componentStates.size() + " = all-component-states state count, invalid.", (Object)this);
        }
    }

    protected int alterStateCount(ComponentState state, int change) {
        Integer newCount = this.componentStateCount.get((Object)state) + change;
        this.checkStateCount(newCount, state);
        this.componentStateCount.put(state, newCount);
        return newCount;
    }

    protected int increaseStateCount(ComponentState state) {
        return this.alterStateCount(state, 1);
    }

    protected int increaseStateCount(ComponentState state, int n) {
        return this.alterStateCount(state, n);
    }

    protected int decreaseStateCount(ComponentState state) {
        return this.alterStateCount(state, -1);
    }

    protected int decreaseStateCount(ComponentState state, int n) {
        return this.alterStateCount(state, -n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPreStart(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPreStart(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start!");
                    }
                    this.start();
                    break;
                }
                case PAUSED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must resume!");
                    }
                    this.resume();
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case RUNNING: {
                    break;
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start! But is in killed state, must be reset()ed first in order to start!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.start();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPreStart(" + agentId + ")");
            }
            this.getComponentControl().localPreStart(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localStart(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localStart(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start!");
                    }
                    this.start();
                    break;
                }
                case PAUSED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must resume!");
                    }
                    this.resume();
                    break;
                }
                case RUNNING: {
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start! But is in killed state, must be reset()ed first in order to start!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.start();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localStart(" + agentId + ")");
            }
            this.getComponentControl().localStart(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPreStartPaused(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPreStartPaused(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused!");
                    }
                    this.startPaused();
                    break;
                }
                case RUNNING: 
                case PAUSED: {
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused! But is in killed state, must be reset()ed first in order to start-paused!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.startPaused();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPreStartPaused(" + agentId + ")");
            }
            this.getComponentControl().localPreStartPaused(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localStartPaused(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localStartPaused(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused!");
                    }
                    this.startPaused();
                    break;
                }
                case RUNNING: 
                case PAUSED: {
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused! But is in killed state, must be reset()ed first in order to start-paused!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.startPaused();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localStartPaused(" + agentId + ")");
            }
            this.getComponentControl().localStartPaused(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPrePause(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPrePause(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPrePause(" + agentId + ")");
            }
            this.getComponentControl().localPrePause(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused!");
                    }
                    this.startPaused();
                    break;
                }
                case RUNNING: {
                    break;
                }
                case PAUSED: {
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantPauseException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused! But is in killed state, must be reset()ed first in order to start-paused!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.startPaused();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPause(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPreStart(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPause(" + agentId + ")");
            }
            this.getComponentControl().localPause(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused!");
                    }
                    this.startPaused();
                    break;
                }
                case RUNNING: {
                    if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are no more starting/running/resuming local component states, must pause!");
                    }
                    this.pause();
                    break;
                }
                case PAUSED: {
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantPauseException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start-paused! But is in killed state, must be reset()ed first in order to start-paused!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.startPaused();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPreResume(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPreResume(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start!");
                    }
                    this.start();
                    break;
                }
                case RUNNING: {
                    break;
                }
                case PAUSED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must resume!");
                    }
                    this.resume();
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantResumeException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must star! But is in killed state, must be reset()ed first in order to start!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.start();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPreResume(" + agentId + ")");
            }
            this.getComponentControl().localPreResume(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localResume(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localResume(" + agentId + ")");
            }
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start!");
                    }
                    this.start();
                    break;
                }
                case RUNNING: {
                    break;
                }
                case PAUSED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must resume!");
                    }
                    this.resume();
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantResumeException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                case KILLED: {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must start! But is in killed state, must be reset()ed first in order to evaluate the state!");
                    }
                    this.reset();
                    if (this.notInState(ComponentState.RESETED)) {
                        throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                    }
                    this.start();
                }
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localResume(" + agentId + ")");
            }
            this.getComponentControl().localResume(agentId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localPreStop(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localPreStop(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPreStop(" + agentId + ")");
            }
            this.getComponentControl().localPreStop(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    break;
                }
                case RUNNING: 
                case PAUSED: {
                    if (this.getStateCount(ComponentState.STARTING, ComponentState.STARTING_PAUSED, ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.STOPPING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are no more running/paused/...  local component states, must stop!");
                    }
                    this.stop();
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localStop(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localStop(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localPreStop(" + agentId + ")");
            }
            this.getComponentControl().localStop(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case INSTANTIATED: 
                case STOPPED: 
                case RESETED: {
                    break;
                }
                case RUNNING: 
                case PAUSED: {
                    if (this.getStateCount(ComponentState.STARTING, ComponentState.STARTING_PAUSED, ComponentState.RUNNING, ComponentState.PAUSING, ComponentState.PAUSED, ComponentState.RESUMING, ComponentState.STOPPING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are no more running/paused/...  local component states, must stop!");
                    }
                    this.stop();
                    break;
                }
                case STARTING: 
                case STARTING_PAUSED: 
                case PAUSING: 
                case RESUMING: 
                case STOPPING: 
                case KILLING: 
                case RESETTING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localKill(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localKill(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                this.log.warning(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localKill(" + agentId + ")");
            }
            this.getComponentControl().localKill(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case KILLING: 
                case KILLED: {
                    break;
                }
                default: {
                    if (this.log != null && this.log.isLoggable(Level.WARNING)) {
                        this.log.warning(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] fatal error has happened inside agent " + agentId + ", killing the component!");
                    }
                    this.kill(agentId, null, null);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void localReset(IAgentId agentId) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] processing localReset(" + agentId + ")");
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling componentControlHelper.localReset(" + agentId + ")");
            }
            if (this.inState(ComponentState.KILLED)) {
                this.reset();
                if (this.notInState(ComponentState.RESETED)) {
                    throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                }
            }
            this.getComponentControl().localReset(agentId);
            switch ((ComponentState)((Object)this.getState().getFlag())) {
                case RESETED: {
                    break;
                }
                case KILLING: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
                }
                default: {
                    throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] component was not killed before, state is " + this.getState().getFlag() + ", INVALID!", this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stateChanged(IAgentId agentId, ComponentState changedValue) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            this.setState(agentId, changedValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(IAgentId agentId, ComponentState newState) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            this.setState(agentId, this.componentStates.get(agentId), newState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(IAgentId agentId, ComponentState oldState, ComponentState newState) {
        Object object = this.ctrlMutex;
        synchronized (object) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] got local state change event: " + agentId + " " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState));
            }
            if ((oldState = newState == null ? this.componentStates.remove(agentId) : this.componentStates.put(agentId, newState)) == newState) {
                return;
            }
            if (oldState == null) {
                this.increaseStateCount(newState);
            } else {
                this.decreaseStateCount(oldState);
                if (newState != null) {
                    this.increaseStateCount(newState);
                }
            }
            this.componentStateCountChanged(agentId, oldState, newState);
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] /PROCESSED/ got local state change event: " + agentId + " " + (Object)((Object)oldState) + " -> " + (Object)((Object)newState));
            }
        }
    }

    protected void componentStateCountChanged(IAgentId origin, ComponentState oldState, ComponentState newState) {
        if (oldState == null) {
            this.newAgentIsUsingTheComponent(origin, newState);
        } else if (newState == null) {
            this.agentStoppedUsingTheComponent(origin, oldState);
        } else {
            this.componentStateChanged(origin, oldState, newState);
        }
    }

    protected void newAgentIsUsingTheComponent(IAgentId agentId, ComponentState state) {
        if (this.log != null && this.log.isLoggable(Level.FINE)) {
            this.log.fine(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] has started to be used by " + agentId);
        }
        switch ((ComponentState)((Object)this.getState().getFlag())) {
            case INSTANTIATED: 
            case STOPPED: 
            case RESETED: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) > 0) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting/running/resuming of local component states is greater than 0, must start!");
                    }
                    this.start();
                    break;
                }
                if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED) <= 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting_paused/pausing/paused of local component states is greater than 0, must start paused!");
                }
                this.startPaused();
                break;
            }
            case RUNNING: {
                break;
            }
            case PAUSED: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) <= 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting/resuming/running of local component states is greater than 0, must resume!");
                }
                this.resume();
                break;
            }
            case STARTING: 
            case STARTING_PAUSED: 
            case PAUSING: 
            case RESUMING: 
            case STOPPING: 
            case RESETTING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case KILLING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case KILLED: {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] must star! But is in killed state, must be reset()ed first in order to start!");
                }
                this.reset();
                if (this.notInState(ComponentState.RESETED)) {
                    throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                }
                this.newAgentIsUsingTheComponent(agentId, state);
            }
        }
    }

    protected void agentStoppedUsingTheComponent(IAgentId agentId, ComponentState oldState) {
        switch ((ComponentState)((Object)this.getState().getFlag())) {
            case INSTANTIATED: 
            case STOPPED: 
            case RESETED: {
                break;
            }
            case RUNNING: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) != 0) break;
                if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSED) > 0) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are only starting-paused/paused component, must pause!");
                    }
                    this.pause();
                    break;
                }
                if (this.getStateCount(ComponentState.PAUSING) != 0 || this.getStateCount(ComponentState.STOPPING) != 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are no running/paused component, must stop!");
                }
                this.stop();
                break;
            }
            case PAUSED: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) == 0) {
                    if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED) > 0 || this.getStateCount(ComponentState.STOPPING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there are no running/paused component, must stop!");
                    }
                    this.stop();
                    break;
                }
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case STARTING: 
            case STARTING_PAUSED: 
            case PAUSING: 
            case RESUMING: 
            case STOPPING: 
            case RESETTING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case KILLING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
        }
    }

    protected void componentStateChanged(IAgentId origin, ComponentState oldState, ComponentState newState) {
        if (newState == ComponentState.KILLED) {
            if (this.inState(ComponentState.KILLED)) {
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] local component has been switched to killed, but we are killed too!");
                }
                return;
            }
            if (this.inState(ComponentState.KILLING)) {
                return;
            }
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] local component has been switched to killed, must kill!");
            }
            this.kill(origin, null, null);
        }
        if (this.getStateCount(ComponentState.KILLING) > 0) {
            if (this.log != null && this.log.isLoggable(Level.FINER)) {
                this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] there is a local component in KILLING state, awaiting its KILLED to tear down the whole system!");
            }
            return;
        }
        switch ((ComponentState)((Object)this.getState().getFlag())) {
            case INSTANTIATED: 
            case STOPPED: 
            case RESETED: {
                if (this.getStateCount(ComponentState.RUNNING) > 0) {
                    throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] the component should have been already running!", (Object)this);
                }
                if (this.getStateCount(ComponentState.PAUSED) > 0) {
                    throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] the component should have been already running/paused!", (Object)this);
                }
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RESUMING) > 0) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting/resuming of local component states is greater than 0, must start!");
                    }
                    this.start();
                    break;
                }
                if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSING) <= 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting-paused/pausing of local component states is greater than 0, must start!");
                }
                this.startPaused();
                break;
            }
            case RUNNING: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) != 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting/resuming/running of local component states is zero!");
                }
                if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSED) > 0) {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting-paused/paused of local component states is greater than 0, there are still agents using the component!");
                    }
                    if (this.getStateCount(ComponentState.PAUSING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] all local components in paused state, must pause!");
                    }
                    this.pause();
                    break;
                }
                if (this.getStateCount(ComponentState.PAUSING) != 0 || this.getStateCount(ComponentState.STOPPING) != 0) break;
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of running/paused of local component states is 0, must stop!");
                }
                this.stop();
                break;
            }
            case PAUSED: {
                if (this.getStateCount(ComponentState.STARTING, ComponentState.RUNNING, ComponentState.RESUMING) == 0) {
                    if (this.getStateCount(ComponentState.STARTING_PAUSED, ComponentState.PAUSING, ComponentState.PAUSED) > 0 || this.getStateCount(ComponentState.STOPPING) != 0) break;
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of running/paused of local component states is 0, must stop!");
                    }
                    this.stop();
                    break;
                }
                if (this.log != null && this.log.isLoggable(Level.FINER)) {
                    this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] number of starting/resuming/running of local component states is > 0, must resume!");
                }
                this.resume();
                break;
            }
            case STARTING: 
            case STARTING_PAUSED: 
            case PAUSING: 
            case RESUMING: 
            case STOPPING: 
            case RESETTING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case KILLING: {
                throw new ComponentCantStartException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] STATE INVALID AT THIS POINT!", this);
            }
            case KILLED: {
                this.reset();
                if (this.notInState(ComponentState.RESETED)) {
                    throw new PogamutException(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] reset has failed, could not resolve the state change.", (Object)this);
                }
                this.componentStateChanged(origin, oldState, newState);
            }
        }
    }

    protected void start() {
        this.setState(ComponentState.STARTING);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling preStart()");
        }
        this.getComponentControl().preStart();
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling start()");
        }
        this.getComponentControl().start();
        this.setState(ComponentState.RUNNING);
    }

    protected void startPaused() {
        this.setState(ComponentState.STARTING_PAUSED);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling preStartPaused()");
        }
        this.getComponentControl().preStartPaused();
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling startPaused()");
        }
        this.getComponentControl().startPaused();
        this.setState(ComponentState.PAUSED);
    }

    protected void pause() {
        this.setState(ComponentState.PAUSING);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling prePause()");
        }
        this.getComponentControl().prePause();
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling pause()");
        }
        this.getComponentControl().pause();
        this.setState(ComponentState.PAUSED);
    }

    protected void resume() {
        this.setState(ComponentState.RESUMING);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling preResume()");
        }
        this.getComponentControl().preResume();
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling resume()");
        }
        this.getComponentControl().resume();
        this.setState(ComponentState.RUNNING);
    }

    protected void stop() {
        this.setState(ComponentState.STOPPING);
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling preStop()");
        }
        this.getComponentControl().preStop();
        if (this.log != null && this.log.isLoggable(Level.FINER)) {
            this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling stop()");
        }
        this.getComponentControl().stop();
        this.setState(ComponentState.STOPPED);
    }

    protected void kill(IAgentId agentId, String message, Throwable cause) {
        if (this.killing) {
            return;
        }
        this.killing = true;
        try {
            String msg;
            block28: {
                block27: {
                    block26: {
                        try {
                            this.setState(ComponentState.KILLING);
                        }
                        catch (Exception e) {
                            if (!this.log.isLoggable(Level.SEVERE)) break block26;
                            this.log.severe(ExceptionToString.process((String)(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] could not set component state to KILLING."), (Throwable)e));
                        }
                    }
                    msg = null;
                    try {
                        msg = String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] " + (agentId == null ? "General component failure." : "Agent " + agentId + " has failed, tearing down the whole team.") + (message != null ? "Reason: " + message : "");
                        for (LocalController ctrl : this.localControllers.values()) {
                            if (ctrl.getAgentId().equals(agentId)) continue;
                            try {
                                ctrl.controller.fatalError(msg, cause);
                            }
                            catch (PogamutException pe) {
                                pe.logExceptionOnce(this.log);
                            }
                            catch (Exception e) {
                                if (!this.log.isLoggable(Level.SEVERE)) continue;
                                this.log.severe(ExceptionToString.process((Throwable)e));
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isLoggable(Level.SEVERE)) break block27;
                        this.log.severe(ExceptionToString.process((String)(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] failed to broadcast fatal error to all other buses."), (Throwable)e));
                    }
                }
                try {
                    if (this.log != null && this.log.isLoggable(Level.FINER)) {
                        this.log.finer(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] calling kill()");
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                try {
                    this.getComponentControl().kill();
                }
                catch (Exception e) {
                    if (!this.log.isLoggable(Level.SEVERE)) break block28;
                    this.log.severe(ExceptionToString.process((String)(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] could not kill the component."), (Throwable)e));
                }
            }
            this.fatalError = agentId == null ? new FatalErrorEvent<SharedComponentController>(this, msg, cause) : this.localControllers.get((Object)agentId).controller.getFatalError();
        }
        finally {
            block31: {
                try {
                    try {
                        this.setState(ComponentState.KILLED);
                    }
                    catch (Exception e) {
                        if (this.log.isLoggable(Level.SEVERE)) {
                            this.log.severe(ExceptionToString.process((String)(String.valueOf(this.id(this.component)) + "[" + this.getState().getFlag() + "] could not set component state to KILLED."), (Throwable)e));
                        }
                        this.killing = false;
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    this.killing = false;
                    throw throwable;
                }
                this.killing = false;
            }
        }
    }

    protected void reset() {
        this.setState(ComponentState.RESETTING);
        this.getComponentControl().reset();
        this.setState(ComponentState.RESETED);
    }

    protected class ComponentStateListener
    implements FlagListener<ComponentState> {
        protected IAgentId agentId;

        public ComponentStateListener(IAgentId agentId) {
            this.agentId = agentId;
        }

        public IAgentId getAgentId() {
            return this.agentId;
        }

        public void flagChanged(ComponentState changedValue) {
            SharedComponentController.this.stateChanged(this.agentId, changedValue);
        }
    }

    protected class ControlHelper
    implements IComponentControlHelper {
        protected IAgentId agentId;

        public ControlHelper(IAgentId agentId) {
            this.agentId = agentId;
        }

        @Override
        public void preStart() throws PogamutException {
            SharedComponentController.this.localPreStart(this.agentId);
        }

        @Override
        public void start() throws PogamutException {
            SharedComponentController.this.localStart(this.agentId);
        }

        @Override
        public void preStartPaused() throws PogamutException {
            SharedComponentController.this.localPreStartPaused(this.agentId);
        }

        @Override
        public void startPaused() throws PogamutException {
            SharedComponentController.this.localStartPaused(this.agentId);
        }

        @Override
        public void prePause() throws PogamutException {
            SharedComponentController.this.localPrePause(this.agentId);
        }

        @Override
        public void pause() throws PogamutException {
            SharedComponentController.this.localPause(this.agentId);
        }

        @Override
        public void preResume() throws PogamutException {
            SharedComponentController.this.localPreResume(this.agentId);
        }

        @Override
        public void resume() throws PogamutException {
            SharedComponentController.this.localResume(this.agentId);
        }

        @Override
        public void preStop() throws PogamutException {
            SharedComponentController.this.localPreStop(this.agentId);
        }

        @Override
        public void stop() throws PogamutException {
            SharedComponentController.this.localStop(this.agentId);
        }

        @Override
        public void kill() {
            SharedComponentController.this.localKill(this.agentId);
        }

        @Override
        public void reset() throws PogamutException {
            SharedComponentController.this.localReset(this.agentId);
        }
    }

    protected class LocalController {
        protected ComponentStateListener listener;
        protected IComponentController controller;

        public LocalController(IAgentId agentId, IComponentController controller) {
            NullCheck.check((Object)agentId, (String)"agentId");
            this.listener = new ComponentStateListener(agentId);
            this.controller = controller;
            NullCheck.check((Object)this.controller, (String)"controller");
            this.controller.getState().addListener((FlagListener)this.listener);
        }

        public IAgentId getAgentId() {
            return this.listener.getAgentId();
        }

        public void destroy() {
            this.controller.getState().removeListener((FlagListener)this.listener);
        }
    }
}

