/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.translator.event;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;

public interface IWorldObjectUpdatedEvent
extends IWorldChangeEvent {
    public WorldObjectId getId();

    public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject var1);

    public static class DestroyWorldObject
    implements IWorldObjectUpdatedEvent {
        private IWorldObject object;
        private long simTime;

        public DestroyWorldObject(IWorldObject object, long simTime) {
            this.object = object;
            NullCheck.check((Object)this.object, (String)"object");
            NullCheck.check((Object)this.object.getId(), (String)"object.getId()");
            this.simTime = simTime;
        }

        @Override
        public WorldObjectId getId() {
            return this.object.getId();
        }

        @Override
        public IWorldObjectUpdateResult<IWorldObject> update(IWorldObject obj) {
            if (obj == null) {
                throw new PogamutException("Could not destroy 'null' object.", (Object)this);
            }
            if (obj.getId() == null || !obj.getId().equals(this.object.getId())) {
                throw new PogamutException("Could not destroy object " + this.object + " as provided object for update is different: " + obj, (Object)this);
            }
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult<Object>(IWorldObjectUpdateResult.Result.DESTROYED, null);
        }

        @Override
        public long getSimTime() {
            return this.simTime;
        }
    }
}

