/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.communication.worldview.impl;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldEventWrapper;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentPausedException;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.lifecyclebus.ILifecycleBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.multi.agent.ITeamedAgentId;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ICompositeWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ILocalWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.ISharedWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.translator.event.IStaticWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.multi.communication.worldview.ISharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.AbstractLocalWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.impl.EventDrivenSharedWorldView;
import cz.cuni.amis.pogamut.multi.communication.worldview.object.ILocalWorldObject;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;

public abstract class EventDrivenLocalWorldView
extends AbstractLocalWorldView {
    public static final String WORLDVIEW_DEPENDENCY = "EventDrivenWorldViewDependency";
    protected boolean receiveEventProcessing = false;
    protected Queue<IWorldChangeEvent> notifyEventsList = new LinkedList<IWorldChangeEvent>();

    public EventDrivenLocalWorldView(ComponentDependencies dependencies, ILifecycleBus bus, IAgentLogger logger, ISharedWorldView sharedWV, ITeamedAgentId agentId) {
        super(dependencies, bus, logger, sharedWV, agentId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notify(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("LocalWorldView notify( " + event.toString() + ")");
        }
        if (this.isPaused()) {
            throw new ComponentPausedException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!(event instanceof ILocalWorldObjectUpdatedEvent)) {
            if (event instanceof ICompositeWorldObjectUpdatedEvent) {
                IWorldChangeEvent partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getSharedEvent();
                if (partEvent != null) {
                    this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                    this.sharedWorldView.notify(partEvent);
                }
                if ((partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getStaticEvent()) != null) {
                    this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                    this.sharedWorldView.notify(partEvent);
                }
            } else if (event instanceof ISharedWorldObjectUpdatedEvent || event instanceof IStaticWorldObjectUpdatedEvent) {
                this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                this.sharedWorldView.notify(event);
                return;
            }
        }
        if (this.receiveEventProcessing) {
            this.notifyEventsList.add(event);
            return;
        }
        this.receiveEventProcessing = true;
        try {
            this.innerNotify(event);
            while (this.notifyEventsList.size() != 0) {
                this.innerNotify(this.notifyEventsList.poll());
            }
        }
        finally {
            this.receiveEventProcessing = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void notifyImmediately(IWorldChangeEvent event) throws ComponentNotRunningException, ComponentPausedException {
        this.log.finest("LocalWorldView notify( " + event.toString() + ")");
        if (this.isPaused()) {
            throw new ComponentPausedException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!this.isRunning()) {
            throw new ComponentNotRunningException((ComponentState)((Object)this.controller.getState().getFlag()), (Object)this);
        }
        if (!(event instanceof ILocalWorldObjectUpdatedEvent)) {
            if (event instanceof ICompositeWorldObjectUpdatedEvent) {
                IWorldChangeEvent partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getSharedEvent();
                if (partEvent != null) {
                    this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                    this.sharedWorldView.notify(partEvent);
                }
                if ((partEvent = ((ICompositeWorldObjectUpdatedEvent)event).getStaticEvent()) != null) {
                    this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                    this.sharedWorldView.notify(partEvent);
                }
            } else if (event instanceof ISharedWorldObjectUpdatedEvent || event instanceof IStaticWorldObjectUpdatedEvent) {
                this.log.finest("Notyfying sharedWV " + event.toString() + ")");
                this.sharedWorldView.notify(event);
                return;
            }
        }
        if (this.receiveEventProcessing) {
            this.notifyEventsList.add(event);
            return;
        }
        this.receiveEventProcessing = true;
        try {
            this.innerNotify(event);
            while (this.notifyEventsList.size() != 0) {
                this.innerNotify(this.notifyEventsList.poll());
            }
        }
        finally {
            this.receiveEventProcessing = false;
        }
    }

    @Override
    protected void raiseEvent(IWorldEvent event) {
        try {
            super.raiseEvent(event);
        }
        catch (Exception e) {
            this.controller.fatalError("Exception raising event " + event, e);
            this.kill();
        }
    }

    protected void innerNotify(IWorldChangeEvent event) {
        NullCheck.check((Object)event, (String)"event");
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("processing " + event);
        }
        if (event instanceof ILocalWorldObjectUpdatedEvent) {
            this.objectUpdatedEvent((ILocalWorldObjectUpdatedEvent)event);
        } else if (event instanceof ICompositeWorldObjectUpdatedEvent) {
            ILocalWorldObjectUpdatedEvent locEvent = ((ICompositeWorldObjectUpdatedEvent)event).getLocalEvent();
            if (locEvent != null) {
                this.objectUpdatedEvent(locEvent);
            }
        } else if (event instanceof IWorldEventWrapper) {
            this.raiseEvent(((IWorldEventWrapper)event).getWorldEvent());
        } else if (event instanceof IWorldEvent) {
            this.raiseEvent((IWorldEvent)((Object)event));
        } else {
            throw new PogamutException("Unsupported event type received (" + event.getClass() + ").", (Object)this);
        }
    }

    protected void objectUpdatedEvent(ILocalWorldObjectUpdatedEvent updateEvent) {
        ILocalWorldObject obj = this.getMostRecentLocalWorldObject(updateEvent.getId());
        ILocalWorldObject copy = null;
        copy = obj != null ? obj.clone() : null;
        IWorldObjectUpdateResult<ILocalWorldObject> updateResult = updateEvent.update(copy);
        switch (updateResult.getResult()) {
            case CREATED: {
                ((EventDrivenSharedWorldView)this.sharedWorldView).addMsgClass(updateResult.getObject().getId(), updateResult.getObject().getCompositeClass());
                this.objectCreated(updateResult.getObject(), updateEvent.getSimTime());
                return;
            }
            case UPDATED: {
                if (updateResult.getObject() != copy) {
                    throw new PogamutException("Update event " + updateEvent + " did not return the same instance of the object (result UPDATED).", (Object)this);
                }
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                this.actLocalWorldObjects.put(copy.getId(), copy);
                this.objectUpdated(copy, updateEvent.getSimTime());
                return;
            }
            case SAME: {
                return;
            }
            case DESTROYED: {
                super.addOldLocalWorldObject(obj, updateEvent.getSimTime());
                this.objectDestroyed(copy, updateEvent.getSimTime());
                return;
            }
        }
        throw new PogamutException("Unhandled object update result " + (Object)((Object)updateResult.getResult()) + " for the object " + obj + ".", (Object)this);
    }

    protected void objectCreated(ILocalWorldObject obj, long time) {
        this.addLocalWorldObject(obj);
    }

    protected void objectUpdated(ILocalWorldObject obj, long time) {
    }

    protected void objectDestroyed(ILocalWorldObject obj, long time) {
        this.removeLocalWorldObject(obj);
    }
}

