/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection;

import cz.cuni.amis.utils.TestOutput;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class Server
extends TestOutput
implements Runnable {
    public static final String GET_COMMAND = "get";
    public static final String QUIT_COMMAND = "quit";
    private int port;
    private String[] response;
    private ServerSocket serverSocket = null;
    private Socket socket = null;
    private boolean tearedDown = false;

    public Server(int port, String[] response) throws IOException {
        super("Server");
        this.port = port;
        this.response = response;
        this.serverSocket = new ServerSocket(this.port);
        new Thread((Runnable)this, "Server").start();
    }

    private void sendResponse(PrintWriter out) {
        for (String s : this.response) {
            if (s == null) continue;
            out.println(s);
            this.push("Sent: " + s);
        }
        out.flush();
    }

    @Override
    public void run() {
        block3: {
            try {
                this.push("Server started");
                this.socket = this.serverSocket.accept();
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                PrintWriter out = new PrintWriter(this.socket.getOutputStream());
                while (true) {
                    String command = in.readLine();
                    this.push("Received: " + command);
                    if (command.equals(QUIT_COMMAND)) break;
                    if (!command.equals(GET_COMMAND)) continue;
                    this.sendResponse(out);
                }
                in.close();
                out.close();
                this.socket.close();
            }
            catch (Exception e) {
                if (this.tearedDown) break block3;
                e.printStackTrace();
            }
        }
        this.push("Server terminated");
    }

    public void tearDown() {
        this.tearedDown = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        return this.port;
    }
}

