/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.factory.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.params.IAgentParameters;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScope;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.guice.AgentTeamScoped;
import cz.cuni.amis.pogamut.base.utils.guice.IAgentScope;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;

public class GuiceAgentModule<PARAMS extends IAgentParameters>
extends AbstractModule {
    private IAgentScope agentScope;
    private IAgentScope agentTeamScope;
    private AdaptableProvider<IAgentId> agentIdProvider = new AdaptableProvider<Object>(null);
    private AdaptableProvider<PARAMS> agentParamsProvider = new AdaptableProvider<Object>(null);
    private List<Module> modules = new ArrayList<Module>();

    public GuiceAgentModule() {
        this.agentScope = this.createAgentScope();
        NullCheck.check((Object)this.agentScope, (String)"createAgentScope()");
        this.agentTeamScope = this.createAgentTeamScope();
        NullCheck.check((Object)this.agentTeamScope, (String)"createAgentTeamScope()");
    }

    public void prepareNewAgent(PARAMS agentParameters) {
        NullCheck.check(agentParameters, (String)"agentParameters");
        NullCheck.check((Object)agentParameters.getAgentId(), (String)"agentParameters.getAgentId()");
        this.agentScope.clearScope();
        this.agentIdProvider.set(agentParameters.getAgentId());
        this.agentParamsProvider.set(agentParameters);
    }

    protected final void addModule(AbstractModule module) {
        this.modules.add((Module)module);
    }

    protected void configureModules() {
        this.addModule(new AbstractModule(){

            protected void configure() {
                this.bind(IComponentBus.class).to(ComponentBus.class);
                this.bind(IAgentId.class).toProvider(GuiceAgentModule.this.getAgentIdProvider());
                this.bind(IAgentParameters.class).toProvider(GuiceAgentModule.this.getAgentParamsProvider());
                this.bind(IAgentLogger.class).to(AgentLogger.class);
            }
        });
    }

    protected IAgentScope createAgentScope() {
        return new AgentScope();
    }

    protected IAgentScope createAgentTeamScope() {
        return new AgentScope();
    }

    public IAgentScope getAgentScope() {
        return this.agentScope;
    }

    public IAgentScope getAgentTeamScope() {
        return this.agentTeamScope;
    }

    protected AdaptableProvider<IAgentId> getAgentIdProvider() {
        return this.agentIdProvider;
    }

    protected AdaptableProvider<PARAMS> getAgentParamsProvider() {
        return this.agentParamsProvider;
    }

    protected final void configure() {
        this.configureModules();
        this.bindScope(AgentScoped.class, this.agentScope);
        this.bindScope(AgentTeamScoped.class, this.agentTeamScope);
        if (this.modules.size() == 0) {
            throw new IllegalStateException("There is no module defined, nobody has ever called addModule() method to introduce new bindings for the module.");
        }
        Module actual = this.modules.get(0);
        for (int i = 1; i < this.modules.size(); ++i) {
            actual = Modules.override((Module[])new Module[]{actual}).with(new Module[]{this.modules.get(i)});
        }
        this.install(actual);
    }
}

