/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.multi.utils.timekey;

import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKey;
import cz.cuni.amis.pogamut.multi.utils.timekey.TimeKeyManager;
import cz.cuni.amis.tests.BaseTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import java.util.ArrayList;
import java.util.Random;
import org.junit.After;
import org.junit.Test;

public class Test01_TimeKey
extends BaseTest {
    @Test
    public void test() {
        int i;
        int num = 500000;
        System.out.println("[INFO] Generating " + num + " keys...");
        ArrayList<TimeKey> keys = new ArrayList<TimeKey>();
        Random rnd = new Random(System.currentTimeMillis());
        for (i = 0; i < num; ++i) {
            keys.add(TimeKey.get((long)rnd.nextLong()));
        }
        System.out.println("[INFO] Sleeping 200ms...");
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException((Throwable)e, (Object)this);
        }
        System.out.println("[INFO] Clearing array holding TimeKey(s)...");
        keys.clear();
        keys = null;
        for (i = 0; (Integer)TimeKey.getInstances().getFlag() > 0 && i < 50; ++i) {
            System.gc();
            System.out.println("[INFO] TimeKey.instances = " + TimeKey.getInstances().getFlag());
            System.out.println("[INFO] (" + (i + 1) + " / 50) Waiting for gc(), sleeping 200ms...");
            try {
                Thread.sleep(200L);
                continue;
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException((Throwable)e, (Object)this);
            }
        }
        System.out.println("[INFO] TimeKey.instances = " + TimeKey.getInstances().getFlag());
        if (Test01_TimeKey.is32Bit()) {
            if ((Integer)TimeKey.getInstances().getFlag() > 0) {
                System.out.println("[ERROR] TimeKeys were not gc()ed!!!");
                throw new RuntimeException("[ERROR] TimeKeys were not gc()ed!!!");
            }
        } else if ((Integer)TimeKey.getInstances().getFlag() > 10) {
            System.out.println("[ERROR] TimeKeys were not gc()ed enough!!!");
            throw new RuntimeException("[ERROR] TimeKeys were not gc()ed enough!!!");
        }
        int size = TimeKey.keys.size();
        boolean error = false;
        if (Test01_TimeKey.is32Bit() && size > 0) {
            error = true;
        }
        if (Test01_TimeKey.is64Bit() && size > 10) {
            error = true;
        }
        if (error) {
            if (Test01_TimeKey.is32Bit()) {
                System.out.println("[ERROR] TimeKey.keys.size() == " + size + " > 0 TimeKey.finalize() IS NOT WORKING CORRECTLY!!!");
                throw new RuntimeException("[ERROR] TimeKey.keys.size() == " + size + " > 0 TimeKey.finalize() IS NOT WORKING CORRECTLY!!!");
            }
            System.out.println("[ERROR] TimeKey.keys.size() == " + size + " > 10 TimeKey.finalize() IS NOT WORKING CORRECTLY!!!");
            throw new RuntimeException("[ERROR] TimeKey.keys.size() == " + size + " > 10 TimeKey.finalize() IS NOT WORKING CORRECTLY!!!");
        }
        if (size == 0) {
            System.out.println("[OK] TimeKey.keys are empty as well!");
        } else {
            System.out.println("[OK] TimeKey.keys are almost-empty as well (64-bit Java)!");
        }
        System.out.println("---/// TEST OK ///---");
    }

    @After
    public void afterTest() {
        try {
            TimeKeyManager.get().unlockAll();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            TimeKey.clear();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

